package com.zorkdata.apiservice.gateway.filter;

import com.zorkdata.apiservice.gateway.schedule.ApiLimitCache;
import io.github.bucket4j.Bucket;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

/**
 * @author zyw
 * @create 2021-10-08-18:37
 */
@Component
@Slf4j
public class GatewayFilter implements GlobalFilter, Ordered {

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String apiName = exchange.getRequest().getQueryParams().getFirst("apiName");
        if(null == apiName){
            exchange.getResponse().setStatusCode(HttpStatus.BAD_REQUEST);
            return exchange.getResponse().setComplete();
        }
        Bucket bucket = ApiLimitCache.BUCKET_CACHE.get(apiName);
        if(null == bucket){
            log.info("接口:{}没有限流",apiName);
            return chain.filter(exchange);
        }else {
            log.info("接口:{}可用调用次数为{}",apiName,bucket.getAvailableTokens());
            if (bucket.tryConsume(1))
            {
                return chain.filter(exchange);
            }
            else
            {
                exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
                return exchange.getResponse().setComplete();
            }
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
