package com.zorkdata.apiservice.gateway.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

import javax.validation.Valid;

/**
 * @author zyw
 * @create 2021-10-08-17:57
 */
@Configuration
public class GateWayConfig {

    @Value("${api-service-address.uri}")
    private String uri;
    @Value("${api-service-address.path}")
    private String path;

    @Bean
    public RouteLocator routeLocator(RouteLocatorBuilder routeLocatorBuilder){
        RouteLocatorBuilder.Builder routes = routeLocatorBuilder.routes();
        routes.route("api-router", r->r.path(path).uri(uri)).build();
        return routes.build();
    }

    @Bean
    public RestTemplate restTemplate()
    {
        return new RestTemplate();
    }
}
