package com.zorkdata.apiservice.controller;

import com.onlyone.paas.common.security.annotation.Inner;
import com.zorkdata.apiservice.BaseController;
import com.zorkdata.apiservice.application.cache.DataSourceCache;
import com.zorkdata.apiservice.application.dbutils.MysqlDataType;
import com.zorkdata.apiservice.domain.domain.DataSource;
import com.zorkdata.apiservice.domain.dto.ApiAuthDTO;
import com.zorkdata.apiservice.domain.dto.ApiDTO;
import com.zorkdata.apiservice.domain.dto.ApiGroupDTO;
import com.zorkdata.apiservice.facade.facade.ApiFacade;
import com.zorkdata.dddlib.api.login.model.BkUser;
import com.zorkdata.dddlib.core.sdk.InvokeResult;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author:changjiazhuang
 * @create:2021/9/2
 */
@Api(tags = "数据服务平台")
@RestController
@RequestMapping(value = "/{version}/dataService/api")
public class ApiServicueController extends BaseController {

    @Autowired
    private ApiFacade apiFacade;

    /**
     * 生成Api分组
     *
     * @return
     */
    @Inner(value = false)
    @GetMapping("/getCurrentUser")
    public InvokeResult getCurrentUser() {
        //读取当前用户
        BkUser user = super.getUser();
        return InvokeResult.success(user);
    }

    @Inner(value = false)
    @PostMapping("/addGroup")
    public InvokeResult addGroup(@RequestBody ApiGroupDTO apiGroupDTO) {
        BkUser user = super.getUser();
        String username = user.getUsername();
        return apiFacade.addGroup(apiGroupDTO, username);
    }

    @Inner(value = false)
    @DeleteMapping("/deleteGroup/{id}")
    public InvokeResult deleteGroup(@PathVariable Integer id) {
        return apiFacade.deleteGroup(id);
    }

    @Inner(value = false)
    @GetMapping("/getGroup/{id}")
    public InvokeResult getGroup(@PathVariable Integer id) {
        return apiFacade.getGroup(id);
    }

    @Inner(value = false)
    @GetMapping("/listDataSource")
    public InvokeResult listDataSource() {
        Map<String, DataSource> dataSources = DataSourceCache.getDataSources();
        Map<String, List<DataSource>> dasourceMap = new HashMap<>(16);
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            DataSource dataSource = entry.getValue();
            if (dataSource.getType() == 2) {
                List<DataSource> mysql = dasourceMap.get("mysql");
                if (mysql == null) {
                    mysql = new ArrayList<>();
                    mysql.add(dataSource);
                } else {
                    mysql.add(dataSource);
                }
                dasourceMap.put("mysql", mysql);
            } else if (dataSource.getType() == 8) {
                List<DataSource> sqlserver = dasourceMap.get("sqlserver");
                if (sqlserver == null) {
                    sqlserver = new ArrayList<>();
                    sqlserver.add(dataSource);
                } else {
                    sqlserver.add(dataSource);
                }
                dasourceMap.put("sqlserver", sqlserver);
            }
        }
        return InvokeResult.success(dasourceMap, "查询数据源列表成功");
    }

    @Inner(value = false)
    @GetMapping("/listGroup")
    public InvokeResult listGroup(@RequestParam(required = false) String keyword,
                                  @RequestParam(required = false, defaultValue = "1") Integer pageNo,
                                  @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                  @RequestParam(required = false, defaultValue = "desc") String sortType,
                                  @RequestParam(required = false) String sortField) {
        return apiFacade.listGroup(keyword, pageSize, pageNo, sortField, sortType);
    }

    /**
     * Api接口
     *
     * @param apiDTO
     * @return
     */
    @Inner(value = false)
    @PostMapping("/addApi")
    public InvokeResult addApi(@RequestBody ApiDTO apiDTO) {
        BkUser user = super.getUser();
        String username = user.getUsername();
        Integer userid = super.getUserId();
        return apiFacade.addApi(apiDTO, username, userid);
    }

    @Inner(value = false)
    @PostMapping("/registApi")
    public InvokeResult registApi(@RequestBody ApiDTO apiDTO) {
        BkUser user = super.getUser();
        String username = user.getUsername();
        Integer userid = super.getUserId();
        return apiFacade.registApi(apiDTO, username, userid);
    }

    @Inner(value = false)
    @DeleteMapping("/deleteApi/{id}")
    public InvokeResult deleteApi(@PathVariable Integer id) {
        return apiFacade.deleteApi(id);
    }

    @Inner(value = false)
    @PostMapping("/addAuth")
    public InvokeResult addAuth(@RequestBody ApiAuthDTO apiAuthDTO) {
        BkUser user = super.getUser();
        String username = user.getUsername();
        return apiFacade.addAuth(apiAuthDTO, username);
    }

    @Inner(value = false)
    @DeleteMapping("/deleteAuth/{id}")
    public InvokeResult deleteAuth(@PathVariable Integer id) {
        return apiFacade.deleteAuth(id);
    }

    @Inner(value = false)
    @PutMapping("/publishApi/{id}")
    public InvokeResult publishApi(@PathVariable Integer id) {
        return apiFacade.publishApi(id);
    }

    @Inner(value = false)
    @PutMapping("/rescindApi/{id}")
    public InvokeResult rescindApi(@PathVariable Integer id) {
        return apiFacade.rescindApi(id);
    }

    @Inner(value = false)
    @GetMapping("/getMyApi/{userId}/{groupId}")
    public InvokeResult getMyApi(@PathVariable("userId") Integer userId,
                                 @PathVariable("groupId") String groupId,
                                 @RequestParam(required = false) String sourceWay,
                                 @RequestParam(required = false) String datasource,
                                 @RequestParam(required = false) String keyword,
                                 @RequestParam(required = false, defaultValue = "1") Integer pageNo,
                                 @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                 @RequestParam(required = false, defaultValue = "desc") String sortType,
                                 @RequestParam(required = false) String sortField
    ) {
        return apiFacade.getMyApi(userId, groupId, keyword, pageNo, pageSize, sortField, sortType, sourceWay, datasource);
    }

    @Inner(value = false)
    @GetMapping("/listMarketApi")
    public InvokeResult listMarketApi(
            @RequestParam(required = false) String keyword,
            @RequestParam(required = false) Long startTime,
            @RequestParam(required = false) Long endTime,
            @RequestParam(required = false, defaultValue = "1") Integer pageNo,
            @RequestParam(required = false, defaultValue = "20") Integer pageSize,
            @RequestParam(required = false, defaultValue = "desc") String sortType,
            @RequestParam(required = false) String sortField
    ) {
        return apiFacade.listMarketApi(keyword, pageNo, pageSize, sortField, sortType, startTime, endTime);
    }

    @Inner(value = false)
    @RequestMapping("/queryApiSingle/{id}")
    public InvokeResult queryApiSingle(@PathVariable Integer id) {
        return apiFacade.queryApiSingle(id);
    }

    @Inner(value = false)
    @RequestMapping("/queryAuthSingle/{apiId}")
    public InvokeResult queryAuthSingle(@PathVariable Integer apiId,
                                        @RequestParam(required = false) String keyword) {
        return apiFacade.queryAuthSingle(apiId, keyword);
    }

    @Inner(value = false)
    @GetMapping("/listUsers")
    public InvokeResult listUsers() {
        return apiFacade.listAllUser();
    }

    @Inner(value = false)
    @GetMapping("/listMysqlDataType")
    public InvokeResult listMysqlDataType() {
        List<String> dataTypes = MysqlDataType.getDataTypes();
        return InvokeResult.success(dataTypes, "获取msql数据类型成功");
    }

    @Inner(value = false)
    @GetMapping("/listMyAuth")
    public InvokeResult listMyAuth(
            @RequestParam(required = false) String keyword,
            @RequestParam(required = false) Long startTime,
            @RequestParam(required = false) Long endTime,
            @RequestParam(required = false, defaultValue = "1") Integer pageNo,
            @RequestParam(required = false, defaultValue = "20") Integer pageSize,
            @RequestParam(required = false, defaultValue = "desc") String sortType,
            @RequestParam(required = false, defaultValue = "created_time") String sortField
    ) {
        BkUser user = super.getUser();
        String username = user.getUsername();
        Integer userid = super.getUserId();
        return apiFacade.listMyAuth(username, pageNo, pageSize, sortField, sortType, startTime, endTime, keyword, userid);
    }

    @Inner(value = false)
    @GetMapping("/dataView/{apiId}/{userId}")
    public InvokeResult dataView(
            @PathVariable Integer userId,
            @PathVariable Integer apiId
    ) {
        BkUser user = super.getUser();
        String username = user.getUsername();
        return apiFacade.dataView(userId, apiId, username);
    }

    @Inner(value = false)
    @GetMapping("/getMysqlDataType")
    public InvokeResult getMysqlDataType() {
        List<String> dataTypes = apiFacade.getMysqlDataType();
        return InvokeResult.success(dataTypes, "获取Mysql数据类型成功!");
    }

    @Inner(value = false)
    @GetMapping("/getSqlServerDataType")
    public InvokeResult getSqlServerDataType() {
        List<String> dataTypes = apiFacade.getSqlServerDataType();
        return InvokeResult.success(dataTypes, "获取SqlServer数据类型成功!");
    }

    @Inner(value = false)
    @GetMapping("/getApiLimit")
    public InvokeResult getApiLimit() {
        return apiFacade.getApiLimit();
    }


    @Value("${api-getway-address}")
    private String getway;

    @Inner(value = false)
    @GetMapping("/getWayPort")
    public InvokeResult getWayPort() {
        return InvokeResult.success(getway);
    }

    @Inner(value = false)
    @PostMapping("/executeApi")
    public InvokeResult executeApi(@RequestParam String apiName,
                                   @RequestBody(required = false) Map<String, String> inParam) {
        BkUser user = super.getUser();
        String username = user.getUsername();
        Integer userid = super.getUserId();
        return apiFacade.executeApi(apiName, inParam, username, userid);
    }


    @Inner(value = false)
    @PutMapping("/csPut/{id}")
    public InvokeResult csPut(@RequestParam String name,
                              @PathVariable Integer id
    ) {
        return InvokeResult.success("测试Put混合条件,更新指定name名称");
    }

    @Inner(value = false)
    @PutMapping("/csPut2")
    public InvokeResult csPut2(@RequestBody ApiDTO apiDTO
    ) {
        return InvokeResult.success("测试Put混合条件,更新指定name名称");
    }

    @PostMapping("/csPost")
    public InvokeResult csPost(@RequestBody ApiGroupDTO apiGroupDTO) {
        return InvokeResult.success("获取SqlServer数据类型成功!");
    }

    @Inner(value = false)
    @PostMapping("/csPost2/{id}")
    public InvokeResult csPost2(
            @PathVariable Integer id,
            @RequestParam String name
    ) {
        return InvokeResult.success("测试Post混合条件");
    }

    @Inner(value = false)
    @DeleteMapping("/delete/{id}")
    public InvokeResult delete(
            @PathVariable Integer id,
            @RequestParam String name
    ) {
        return InvokeResult.success("测试Post混合条件");
    }

}
