package com.zorkdata.apiservice.facade.facade;


import com.zorkdata.apiservice.domain.dto.ApiAuthDTO;
import com.zorkdata.apiservice.domain.dto.ApiDTO;
import com.zorkdata.apiservice.domain.dto.ApiGroupDTO;
import com.zorkdata.dddlib.core.sdk.InvokeResult;

import java.util.List;
import java.util.Map;

/**
 * @author:changjiazhuang
 * @create:2021/9/3
 */

public interface ApiFacade {

    /**
     * 获取当前系统用户列表
     *
     * @return
     */
    InvokeResult listAllUser();

    /**
     * 获取数据源列表
     *
     * @return
     */
    InvokeResult queryDatasourceList();

    /**
     * 添加接口分组
     *
     * @param apiGroupDTO
     * @param username
     * @return
     */
    InvokeResult addGroup(ApiGroupDTO apiGroupDTO, String username);

    /**
     * 删除接口分组
     *
     * @param id
     * @return
     */
    InvokeResult deleteGroup(Integer id);

    /**
     * 查询单个分组接口
     *
     * @param id
     * @return
     */
    InvokeResult getGroup(Integer id);

    /**
     * 查询接口分组列表
     *
     * @param keyword
     * @param pageSize
     * @param pageNo
     * @param sortField
     * @param sortType
     * @return
     */
    InvokeResult listGroup(String keyword, Integer pageSize, Integer pageNo, String sortField, String sortType);


    /**
     * 新增Api接口
     *
     * @param apiDTO
     * @param username
     * @param userid
     * @return
     */
    InvokeResult addApi(ApiDTO apiDTO, String username, Integer userid);

    /**
     * 删除Api接口
     *
     * @param id
     * @return
     */
    InvokeResult deleteApi(Integer id);

    /**
     * 添加接口授权
     *
     * @param apiAuthDTO
     * @param username
     * @return
     */
    InvokeResult addAuth(ApiAuthDTO apiAuthDTO, String username);

    /**
     * 删除授权接口
     *
     * @param id
     * @return
     */
    InvokeResult deleteAuth(Integer id);

    /**
     * 发布接口
     *
     * @param id
     * @return
     */
    InvokeResult publishApi(Integer id);

    /**
     * 撤销发布接口
     *
     * @param id
     * @return
     */
    InvokeResult rescindApi(Integer id);

    /**
     * 生成注册Api
     *
     * @param apiDTO
     * @param username
     * @param userid
     * @return
     */
    InvokeResult registApi(ApiDTO apiDTO, String username, Integer userid);


    /**
     * 查询我创建的Api
     *
     * @param userId
     * @param groupId
     * @param keyword
     * @param pageNo
     * @param pageSize
     * @param sortField
     * @param sortType
     * @param sourceWay
     * @param datasource
     * @return
     */
    InvokeResult getMyApi(Integer userId, String groupId, String keyword, Integer pageNo, Integer pageSize, String sortField, String sortType, String sourceWay, String datasource);

    /**
     * 查看API市场
     *
     * @param keyword
     * @param pageNo
     * @param pageSize
     * @param sortField
     * @param sortType
     * @param startTime
     * @param endTime
     * @return
     */
    InvokeResult listMarketApi(String keyword, Integer pageNo, Integer pageSize, String sortField, String sortType, Long startTime, Long endTime);

    /**
     * 查看我授权的api
     *
     * @param username
     * @param pageNo
     * @param pageSize
     * @param sortField
     * @param sortType
     * @param startTime
     * @param endTime
     * @param keyword
     * @param userid
     * @return
     */
    InvokeResult listMyAuth(String username, Integer pageNo, Integer pageSize, String sortField, String sortType, Long startTime, Long endTime, String keyword, Integer userid);

    /**
     * 数据预览
     *
     * @param userId
     * @param apiId
     * @param username
     * @return
     */
    InvokeResult dataView(Integer userId, Integer apiId, String username);


    /**
     * ll
     *
     * @param apiName
     * @param inParam
     * @param username
     * @param userid
     * @return
     */
    InvokeResult<Void> executeApi(String apiName, Map<String, String> inParam, String username, Integer userid);

    /**
     * 获取Mysql数据类型
     *
     * @return
     */
    List<String> getMysqlDataType();

    /**
     * 获取SqlServer数据类型
     *
     * @return
     */
    List<String> getSqlServerDataType();

    /**
     * 根据id查询api
     *
     * @param id
     * @return
     */
    InvokeResult queryApiSingle(Integer id);

    /**
     * 根据apiId查询Auth
     *
     * @param apiId
     * @param keyword
     * @return
     */
    InvokeResult queryAuthSingle(Integer apiId, String keyword);

    /**
     * 获取Api   Limit,name属性
     *
     * @return
     */
    InvokeResult getApiLimit();


}
