package com.zorkdata.apiservice.domain.repository;

import com.zorkdata.apiservice.domain.domain.Api;
import com.zorkdata.dddlib.domain.EntityRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title: ApiServiceRepositoryB
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/10 010-0:00
 */
@Repository
public interface ApiRepository extends EntityRepository<Api, Integer> {


    /**
     * 非空判断,查询该id是否存在
     *
     * @param id
     * @return
     */
    @Query(value = "select count(*) from api where id= ?1", nativeQuery = true)
    Integer selectCountFromId(Integer id);

    /**
     * 非空判断,查询该userid是否存在
     *
     * @param userId
     * @return
     */
    @Query(value = "select count(*) from api where user_id= ?1", nativeQuery = true)
    Integer selectCountFromUserId(Integer userId);

    /**
     * listMyAuth
     *
     * @param keyword
     * @param sortType
     * @param sortField
     * @param pageNo
     * @param pageSize
     * @param userid
     * @param start
     * @param end
     * @return
     */
    @Query(value = " select a.* from `api_auth` ap left join api a on a.id = ap.api_id where (a.name like CONCAT ('%',?1,'%') or a.description like CONCAT ('%',?1,'%') or a.created_by like CONCAT ('%',?1,'%')) and ap.user_id = ?6 and a.updated_time between ?7 and ?8 order by ?2 ?3 limit ?4,?5  ", nativeQuery = true)
    List<Api> listMyAuth(String keyword, String sortType, String sortField, Integer pageNo, Integer pageSize, Integer userid, String start, String end);

    /**
     * listMyAuth
     *
     * @param keyword
     * @param userid
     * @param start
     * @param end
     * @return
     */
    @Query(value = " select count(*) from `api_auth` ap left join api a on a.id = ap.api_id where (a.name like CONCAT ('%',?1,'%') or a.description like CONCAT ('%',?1,'%') or a.created_by like CONCAT ('%',?1,'%')) and ap.user_id = ?2 and a.updated_time between ?3 and ?4 ", nativeQuery = true)
    Integer listMyAuthCount(String keyword, Integer userid, String start, String end);

    /**
     * listMyAuth2
     *
     * @param keyword
     * @param sortType
     * @param sortField
     * @param pageNo
     * @param pageSize
     * @param userid
     * @return
     */
    @Query(value = " select a.* from `api_auth` ap left join api a on a.id = ap.api_id where (a.name like CONCAT ('%',?1,'%') or a.description like CONCAT ('%',?1,'%') or a.created_by like CONCAT ('%',?1,'%')) and ap.user_id = ?6  order by ?2 ?3 limit ?4,?5  ", nativeQuery = true)
    List<Api> listMyAuthTwo(String keyword, String sortType, String sortField, Integer pageNo, Integer pageSize, Integer userid);

    /**
     * listMyAuth2
     *
     * @param keyword
     * @param userid
     * @return
     */
    @Query(value = " select count(*) from `api_auth` ap left join api a on a.id = ap.api_id where (a.name like CONCAT ('%',?1,'%') or a.description like CONCAT ('%',?1,'%') or a.created_by like CONCAT ('%',?1,'%')) and ap.user_id = ?2 ", nativeQuery = true)
    Integer listMyAuthTwoCount(String keyword, Integer userid);

    /**
     * selectApiName
     *
     * @param name
     * @return
     */
    @Query(value = "select count(*) from api where name= ?1 ", nativeQuery = true)
    Integer selectApiName(String name);

    /**
     * findByName
     *
     * @param name
     * @return
     */
    @Query(value = "select * from api where name = ?1 ", nativeQuery = true)
    Api findByName(String name);

    /**
     * findByApiId
     *
     * @param apiId
     * @return
     */
    @Query(value = "select * from api where id = ?1 ", nativeQuery = true)
    Api findByApiId(Integer apiId);

    /**
     * findUserIdByUsername
     *
     * @param username
     * @return
     */
    @Query(value = "select user_id from api where created_by = ?1 ", nativeQuery = true)
    Integer findUserIdByUsername(String username);

    /**
     * 根据apiName查找状态
     *
     * @param apiName
     * @return
     */
    @Query(value = "select status from api where name = ?1 ", nativeQuery = true)
    Integer findStatusByName(String apiName);

    /**
     * 根据apiId查询createUid
     *
     * @param apiId
     * @return
     */
    @Query(value = "select user_id from api where id = ?1 ", nativeQuery = true)
    Integer findCreateUidByApiId(Integer apiId);

    /**
     * 根据apiId查询白名单
     *
     * @param apiId
     * @return
     */
    @Query(value = "select white_list from api where id = ?1 ", nativeQuery = true)
    String findWhiteList(Integer apiId);

    /**
     * 根据apiId查询api_Call数量
     *
     * @param id
     * @return
     */
    @Query(value = "select count(*) from api_call where api_id = ?1 ", nativeQuery = true)
    Integer findCountByApiCall(Integer id);

    /**
     * 查询24小时调用次数
     *
     * @param apiId
     * @param startTime
     * @param endTime
     * @return
     */
    @Query(value = "select count(*) from api_call where api_id = ?1 and call_time >= ?2 and call_time <= ?3", nativeQuery = true)
    Integer findLastCall24ByApiCall(Integer apiId, Date startTime, Date endTime);


    /**
     * 查询api name & limit
     * @return
     */
    @Query(value = "select `name`,single_limit from api where status = 1",nativeQuery = true)
    List<Map<String,Integer>> findLimitAndName();
}
