package com.zorkdata.apiservice.domain.repository;

import com.zorkdata.apiservice.domain.domain.ApiAuth;
import com.zorkdata.apiservice.domain.dto.ApiAuthDTO;
import io.swagger.models.auth.In;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title: ApiServiceAuthRepository
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/10 010-1:35
 */
public interface ApiAuthRepository extends JpaRepository<ApiAuth, Integer>, JpaSpecificationExecutor<ApiAuth> {
    /**
     * 非空判断,查询该id是否存在
     *
     * @param userId
     * @param apiId
     * @return
     */
    @Query(value = "select count(*) from api_auth where user_id= ?1 and api_id = ?2", nativeQuery = true)
    Integer selectUserId(Integer userId, Integer apiId);

    /**
     * 查看api发布状态
     *
     * @param apiId
     * @return
     */
    @Query(value = "select status from api where id= ?1", nativeQuery = true)
    Integer selectApiStatus(Integer apiId);

    /**
     * 获取api_id
     *
     * @param id
     * @return
     */
    @Query(value = "select api_id from api_auth where id= ?1", nativeQuery = true)
    Integer selectApiId(Integer id);


    /**
     * 根据apiId查询
     *
     * @param apiId
     * @return
     */
    @Query(value = "select user_id from api_auth where api_id= ?1", nativeQuery = true)
    List<Integer> findByApiId(Integer apiId);

    /**
     * 根据apiId,查询对应的apiAuth信息
     *
     * @param apiId
     * @param userid
     * @return
     */
    @Query(value = "select start_time , end_time from api_auth where api_id= ?1 and user_id = ?2", nativeQuery = true)
    Map<Date, Date> findApiAuthByApiId(Integer apiId, Integer userid);


    /**
     * 根据apiid查询ApiAuth里是否存在权限
     *
     * @param id
     * @return
     */
    @Query(value = "select count(*)  from api_auth where api_id= ?1", nativeQuery = true)
    Integer findAuthApiIdById(Integer id);

    /**
     * 根据apiid查询ApiAuth里limit次数
     *
     * @param apiId
     * @param userid
     * @return
     */
    @Query(value = "select limit_num from api_auth where api_id= ?1 and user_id = ?2", nativeQuery = true)
    Integer findApiAuthLimitByApiId(Integer apiId, Integer userid);


    /**
     * 更新ApiAuth表内Lmit_num次数
     *
     * @param apiId
     * @param userid
     */
    @Modifying
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update api_auth set limit_num = limit_num - 1 where api_id= ?1 and user_id = ?2", nativeQuery = true)
    void updateApiAuthLimitNum(Integer apiId, Integer userid);
}
