package com.zorkdata.apiservice.domain.dto;

import com.zorkdata.apiservice.domain.domain.ApiGroup;
import com.zorkdata.apiservice.domain.domain.ConstParam;
import com.zorkdata.apiservice.domain.listdto.WhiteListDTO;
import lombok.Data;

import java.util.Date;
import java.util.List;


/**
 * @author lixinfeng
 * @title: Api  接口
 * @date 2021/09/07
 */
@Data
public class ApiDTO {
    /**
     * 主键ID
     */
    private Integer id;
    /**
     * 接口名称
     */
    private String name;
    /**
     * 请求路径
     */
    private String path;

    /**
     * 描述
     */
    private String description;
    /**
     * 调用超时时间(秒)
     */
    private Integer overtime;
    /**
     * 单用户每秒调用次数限制
     */
    private Integer singleLimit;
    /**
     * 协议
     */
    private String protocol;
    /**
     * 请求方式
     */
    private String requestType;
    /**
     * 返回类型
     */
    private String returnType;
    /**
     * 白名单
     */
    private List<WhiteListDTO> whiteList;
    /**
     * 所属分组
     */
    private ApiGroup group;
    /**
     * 数据源
     */
    private DataSourceDTO datasource;
    /**
     * 是否分页
     */
    private Integer page;
    private Integer totalCall;
    /**
     * 后端 Host
     */
    private String sourceHost;
    /**
     * 后端路径
     */
    private String sourcePath;
    /**
     * 返回结果是否携带分页参数
     */
    private Integer pageParam;
    /**
     * sql语句
     */
    private String querySql;
    /**
     * 表名
     */
    private String dataTable;
    /**
     * 正常结果返回示例
     */
    private String rightCase;
    /**
     * 异常结果返回示例
     */
    private String excepitonCase;
    /**
     * 状态 0:未发布 1: 已发布
     */
    private Integer status;
    /**
     * 用户id,接口生成者或注册者
     */
    private Integer userId;
    /**
     * 接口来源 :create 生成  regist注册
     */
    private String sourceWay;
    /**
     * 错误码定义
     */
    private String errorCode;
    /**
     * 创建者
     */
    private String createdBy;
    /**
     * 创建时间
     */
    private Date createdTime;
    /**
     * 更新者
     */
    private String updatedBy;
    /**
     * 更新时间
     */
    private Date updatedTime;

    private List<RequestParamDTO> requestParam;

    private List<ReturnParamDTO> returnParam;

    private List<ConstParamDTO> constParams;



}
