package com.zorkdata.apiservice.domain.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * @title: ApiGroup 接口分组
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/7 007-14:58
 */
@Table(name = "api_group")
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
public class ApiGroup {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Integer id;

    /**
     * 接口分组名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 父节点id
     */
    @Column(name = "parent_id")
    private Integer parentId;

    /**
     * 创建者
     */
    @Column(name = "created_by")
    private String createdBy;

    /**
     * 创建时间
     */
    @Column(name = "created_time",insertable = true, updatable = false, columnDefinition = "TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    @CreatedDate
    private Date createdTime;

    /**
     * 更新者
     */
    @Column(name = "updated_by")
    private String updatedBy;

    /**
     * 更新时间
     */
    @Column(name = "updated_time")
    @LastModifiedDate
    private Date updatedTime;

    /**
     * 节点描述
     */
    @Column(name = "description")
    private String description;


}










