package com.zorkdata.apiservice.domain.domain;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * @title: ApiAuth  接口权限
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/7 007-14:58
 */
@Table(name = "api_auth")
@Data
@Entity
public class ApiAuth {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Integer id;
    /**
     * 接口id
     */
    @Column(name = "api_id")
    private Integer apiId;
    /**
     * 授权用户
     */
    @Column(name = "user_id")
    private Integer userId;
    /**
     * 授权用户名称
     */
    @Column(name = "username")
    private String username;
    /**
     * 调用次数限制
     */
    @Column(name = "limit_num")
    private Integer limitNum;
    /**
     * 是否限制调用次数
     */
    @Column(name = "limitb")
    private Integer limit;
    /**
     * 开始限制时间
     */
    @Column(name = "start_time")
    private Date startTime;
    /**
     * 结束限制时间
     */
    @Column(name = "end_time")
    private Date endTime;
    /**
     * 是否限制调用周期
     */
    @Column(name = "limit_time")
    private Integer limitTime;
    /**
     * 创建者
     */
    @Column(name = "created_by")
    private String createdBy;
    /**
     * 不知道
     */
    @Column(name = "auth_time")
    private Date authTime;


}
