package com.zorkdata.apiservice.domain.assembler;

import com.google.gson.Gson;
import com.zorkdata.apiservice.domain.domain.ApiAuth;
import com.zorkdata.apiservice.domain.domain.ApiGroup;
import com.zorkdata.apiservice.domain.dto.ApiAuthDTO;
import com.zorkdata.apiservice.domain.dto.ApiGroupDTO;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @title: ApiAuthAssembler
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/10 010-1:37
 */
public class ApiAuthAssembler {

    public static ApiAuth toApiAuth(ApiAuthDTO apiAuthDTO, String username) {
        ApiAuth apiAuth = new ApiAuth();
        if (0 == apiAuthDTO.getId()) {
            apiAuth.setAuthTime(new Date());
            apiAuth.setCreatedBy(username);
        } else {
            apiAuth.setAuthTime(new Date());
            apiAuth.setId(apiAuthDTO.getId());
        }
        apiAuth.setApiId(apiAuthDTO.getApiId());
        apiAuth.setUserId(apiAuthDTO.getUserId());
        apiAuth.setLimitNum(apiAuthDTO.getLimitNum());
        apiAuth.setLimit(apiAuthDTO.getLimit());
        apiAuth.setStartTime(apiAuthDTO.getStartTime());
        apiAuth.setEndTime(apiAuthDTO.getEndTime());
        apiAuth.setLimitTime(apiAuthDTO.getLimitTime());
        apiAuth.setUsername(apiAuthDTO.getUsername());
        return apiAuth;
    }

    public static List<ApiAuthDTO> toApiAuthDTOList(List<ApiAuth> apiAuthList) {
        ApiAuthDTO apiAuthDTO = null;
        List<ApiAuthDTO>  apiAuthDTOList= new ArrayList<>();
        for (ApiAuth apiAuth : apiAuthList) {
            apiAuthDTO=new ApiAuthDTO();
            apiAuthDTO.setApiId(apiAuth.getApiId());
            apiAuthDTO.setAuthTime(apiAuth.getAuthTime());
            apiAuthDTO.setId(apiAuth.getId());
            apiAuthDTO.setLimit(apiAuth.getLimitNum());
            apiAuthDTO.setCreatedBy(apiAuth.getCreatedBy());
            apiAuthDTO.setEndTime(apiAuth.getEndTime());
            apiAuthDTO.setStartTime(apiAuth.getStartTime());
            apiAuthDTO.setUserId(apiAuth.getUserId());
            apiAuthDTO.setLimitNum(apiAuth.getLimitNum());
            apiAuthDTO.setLimitTime(apiAuth.getLimitTime());
            apiAuthDTO.setUsername(apiAuth.getUsername());
            apiAuthDTOList.add(apiAuthDTO);

        }
        return apiAuthDTOList;
    }


}
