package com.zorkdata.apiservice.application.dbutils;

import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.Version;
import lombok.extern.slf4j.Slf4j;

import java.io.StringWriter;
import java.util.Map;

/**
 * @author zyw
 * @create 2021-09-17-13:14
 */
@Slf4j
public class FreemarkUtil {
    private FreemarkUtil(){}

    private static Version version = new Version(2, 3, 0);

    public static String freemarkerProcess(Map input, String templateStr, String content) {
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        String template = content;
        stringLoader.putTemplate(template, templateStr);
        Configuration cfg = new Configuration(version);
        cfg.setTemplateLoader(stringLoader);
        try {
            Template templateCon = cfg.getTemplate(template);
            StringWriter writer = new StringWriter();
            templateCon.process(input, writer);
            return writer.toString();
        } catch (Exception e) {
            log.error("报错", e);
        }
        return null;
    }
}
