/*
 *
 *  *
 *  *                   888
 *  *                   888
 *  *                   888
 *  *  .d88b.  88888b.  888 888  888  .d88b.  88888b.   .d88b.
 *  * d88""88b 888 "88b 888 888  888 d88""88b 888 "88b d8P  Y8b
 *  * 888  888 888  888 888 888  888 888  888 888  888 88888888
 *  * Y88..88P 888  888 888 Y88b 888 Y88..88P 888  888 Y8b.
 *  *  "Y88P"  888  888 888  "Y88888  "Y88P"  888  888  "Y8888
 *  *                            888
 *  *                       Y8b d88P
 *  *                        "Y88P"
 *  *
 *  *
 *  *                      made by googe
 *
 */


package com.zorkdata.apiservice.common.api.feign.fallback;

import com.zorkdata.apiservice.common.api.feign.RemoteAuthCenterService;
import com.zorkdata.dddlib.core.sdk.InvokeResult;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author googe
 * @date 2020/2/1
 */
@Slf4j
@Component
public class RemoteAuthCenterServiceFallbackImpl implements RemoteAuthCenterService {
    @Setter
    private Throwable cause;

    @Override
    public InvokeResult registSystemAuth(Map<String, Object> regSystemStr, String from) {
        log.error("feign 注册系统、菜单、资源、权限信息失败:{}", regSystemStr, cause);
        return null;
    }

    /**
     * 查询所有用户
     *
     * @param from 调用标志
     * @return R
     */
    @Override
    public InvokeResult fetchAllUserFromAuth(String from) {
        log.error("feign 查询所有用户失败:{}", cause);
        return null;
    }

    /**
     * 根据用户名查询用户
     *
     * @param userName 用户名称
     * @param from     调用标志
     * @return
     */
    @Override
    public InvokeResult getUserByUserName(String userName, String from) {
        log.error("feign 根据用户名查询用户失败:{}", userName, cause);
        return null;
    }


    /**
     * 根据用户id集合查询用户
     *
     * @param ids  用户集合
     * @param from 调用标志
     * @return
     */
    @Override
    public InvokeResult getUsersByIds(String ids, String from) {
        log.error("feign 根据用户id集合查询用户失败:{}", ids, cause);
        return null;
    }

    /**
     * 判断当前系统系该用户是否为管理员
     *
     * @param appCode 系统code
     * @param userId  当前系统登录用户id
     * @param from
     * @return
     */
    @Override
    public InvokeResult isSystemAdministrator(String appCode, Integer userId, String from) {
        log.error("feign 判断当前系统系该用户是否为管理员失败:{}", appCode, userId, cause);
        return null;
    }
}
