package com.zorkdata.apiservice.common.api.feign.factory;

import com.zorkdata.apiservice.common.api.feign.RemoteSmartService;
import com.zorkdata.apiservice.common.api.feign.fallback.RemoteSmartServiceFallbackImpl;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @title: RemoteSmartServiceFallbackFactory
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/9 009-14:36
 */
@Component
public class RemoteSmartServiceFallbackFactory  implements FallbackFactory<RemoteSmartService> {
    @Override
    public RemoteSmartService create(Throwable cause) {
        RemoteSmartServiceFallbackImpl remoteSmartService = new RemoteSmartServiceFallbackImpl();
        remoteSmartService.setCause(cause);
        return remoteSmartService;
    }
}
