/*
 *
 *  *
 *  *                   888
 *  *                   888
 *  *                   888
 *  *  .d88b.  88888b.  888 888  888  .d88b.  88888b.   .d88b.
 *  * d88""88b 888 "88b 888 888  888 d88""88b 888 "88b d8P  Y8b
 *  * 888  888 888  888 888 888  888 888  888 888  888 88888888
 *  * Y88..88P 888  888 888 Y88b 888 Y88..88P 888  888 Y8b.
 *  *  "Y88P"  888  888 888  "Y88888  "Y88P"  888  888  "Y8888
 *  *                            888
 *  *                       Y8b d88P
 *  *                        "Y88P"
 *  *
 *  *
 *  *                      made by googe
 *
 */


package com.zorkdata.apiservice.common.api.feign;

import com.onlyone.paas.common.core.constant.SecurityConstants;
import com.zorkdata.apiservice.common.api.feign.factory.RemoteAuthCenterServiceFallbackFactory;
import com.zorkdata.dddlib.core.sdk.InvokeResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author googe
 * @date 2020/2/1
 */
@FeignClient(contextId = "apiServiceRemoteAuthCenterService", value = "authcenter", fallbackFactory = RemoteAuthCenterServiceFallbackFactory.class)
public interface RemoteAuthCenterService {
    /**
     * 注册系统信息
     *
     * @param regSystemStr 系统信息
     * @param from         调用标志
     * @return R
     */
    @PostMapping("/v1/auth/registSystem")
    InvokeResult registSystemAuth(@RequestBody Map<String, Object> regSystemStr, @RequestHeader(SecurityConstants.FROM) String from);

    /**
     * 查询所有用户
     *
     * @param from 调用标志
     * @return R
     */
    @GetMapping("/v1/user/getAllUser")
    InvokeResult fetchAllUserFromAuth(@RequestHeader(SecurityConstants.FROM) String from);

    /**
     * 根据用户名查询用户
     *
     * @param userName 用户名称
     * @param from     调用标志
     * @return R
     */
    @GetMapping("/v1/user/getUserByUserName")
    InvokeResult getUserByUserName(@RequestParam("userName") String userName, @RequestHeader(SecurityConstants.FROM) String from);

    /**
     * 根据用户id集合查询用户
     *
     * @param ids  用户ids集合
     * @param from 调用标志
     * @return R
     */
    @GetMapping("/v1/user/getUsersByIds")
    InvokeResult getUsersByIds(@RequestParam("ids") String ids, @RequestHeader(SecurityConstants.FROM) String from);

    /**
     * 判断当前系统系该用户是否为管理员
     * @param appCode 系统code
     * @param userId  当前系统登录用户id
     * @param from
     * @return
     */
    @GetMapping("/auth/isSystemAdministrator")
    InvokeResult isSystemAdministrator(@RequestParam("appCode") String appCode, @RequestParam("userId") Integer userId, @RequestHeader(SecurityConstants.FROM) String from);

}
