package com.zorkdata.apiservice.config.bean;

import com.onlyone.paas.common.security.service.PigUser;
import com.zorkdata.dddlib.api.login.model.BkUser;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * @author : hubinbin
 * @date : 2020/6/1
 */
@Data
public class UserWapper extends BkUser {
    private static Logger logger = LoggerFactory.getLogger(UserWapper.class);
    private PigUser principal;
    private BkUser bkUser;

    public UserWapper(PigUser principal) {
        this.principal = principal;
        this.bkUser = new BkUser();
        this.bkUser.setUsername(null == principal ? "admin" : principal.getUsername());
        try {
            if (null != bkUser) {
                reflectToWapper(bkUser, this);
            }
        } catch (Exception e) {
            logger.error("构造UserWapper失败，原因:" + e.getMessage());
        }
    }

    /**
     * 将父类反射到增强类
     *
     * @param father
     * @param child
     * @param <T>
     * @throws Exception
     */
    public static <T> void reflectToWapper(T father, T child) throws Exception {
        if (child.getClass().getSuperclass() != father.getClass()) {
            throw new Exception("child 不是 father 的子类");
        }
        Class<?> fatherClass = father.getClass();
        Field[] declaredFields = fatherClass.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; i++) {
            Field field = declaredFields[i];
            Method method = fatherClass.getDeclaredMethod("get" + upperHeadChar(field.getName()));
            Object obj = method.invoke(father);
            field.setAccessible(true);
            field.set(child, obj);
        }

    }

    /**
     * 首字母大写，in:deleteDate，out:DeleteDate
     */
    public static String upperHeadChar(String in) {
        String head = in.substring(0, 1);
        String out = head.toUpperCase() + in.substring(1, in.length());
        return out;
    }
}
