package com.zorkdata.apiservice;

import com.onlyone.paas.common.security.annotation.EnableOnlyFeignClients;
import com.onlyone.paas.common.security.annotation.EnableOnlyResourceServer;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.client.SpringCloudApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * 启动嵌入式的Tomcat并初始化Spring环境.
 * <p>
 * 全新的无任何spring的xml配置，
 * <p>
 * 1. 扫描当前package下的class设置自动注入的Bean<br/>
 * 2. 支持用@Bean标注的类配置Bean <br/>
 * 3. 根据classpath中的三方包Class以及application.properties条件配置三方包 <br/>
 * 4. 支持用@Configuration标注的类配置三方包.
 * </p>
 * <p>
 * 某些情况下可能仍然需要xml配置文件，可以用注释@ImportResource来引入Spring的配置文件
 * <p>
 * SpringBoot采用约定大于配置的风格，默认加载了大量自动配置加载类，比如DataSourceAutoConfiguration数据库配置，<br/>
 * 来简化开发者的配置，并在启动时自动创建数据库连接，但如果应用中确实不需要数据库，则会报错，可以在启动类增加注解：<br/>
 *
 * @author googe
 * @ EnableAutoConfiguration(exclude = {DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
 * <br/>来取消自动数据库配置。
 */

/**
 * @author: googe (<a href="mailto:gujunling@zorkdata.com.cn">gujunling@zorkdata.com.cn</a>)
 * @date: 2020/4/3
 */
@EnableOnlyResourceServer
@EnableOnlyFeignClients
@SpringCloudApplication
@ComponentScan(basePackages = {"com.zorkdata", "com.zorkdata.apiservice",})
@EnableFeignClients
@EnableAsync
public class WebApplication {

    public static void main(String[] args) {
        SpringApplication.run(WebApplication.class, args);
    }

}
