# 数据服务平台详细设计

上海中畅数据技术有限公司 2021年9月

***

[文档修订履历]

| 版本号 | 修订日期       | 修订人 | 修订说明 |
| ------ | -------------- | ------ | -------- |
| v0.1  | 2021年09月01日 | 朱允伟 | 提供初版 |
|        |  |        |          |

***

目录

[TOC]


## 一、引言

### 1.1 编写目的

    本详细设计说明主要针对iDais数据平台的数据服务模块，在数据服务模块中，搭建企业统一的数据服务总线。快速、低成本、低风险地实现微服务聚合。明确开发规约与系统详细功能模块的实现;系统与其他系统的接口问题，以及用户的各种功能、界面等需求帮助开发人员、测试人员了解系统所提供具体功能是否满足本身期望要求，为开发人员进行开发提供依据，帮助管理人员、开发人员、测试人员及时发现系统中存在的不足，更快、更好、更有效的完善系统。
    本设计说明书的预期读者为：系统管理员、系统测试员、编码开发人员,测试人员

### 1.2 项目背景

    来源中畅数据产品设计部。

### 1.3 定义

### 1.4 参考资料

| [数据服务平台需求文档])
| [数据服务平台原型图](https://www.wulihub.com.cn/gc/JYoZ75/index.html#g=1&p=idais__&c=1)

***

## 二、任务概述

### 2.1 目标

    1、iDais 数据平台，接口管理角色和普通用户角色,管理角色可以创建API,普通用户角色只能查看被授权的接口信息。
    2、概览模块展示接口的数量,调用情况,及调用成功失败等信息.
    3、API市场,平台的接口一览表,可以查看接口的定义,参数及有权限的接口的调用等功能
    4、API管理,提供接口的注册,生成,及对应的编辑,发布,设置权限,删除,测试等功能

### 2.2 运行环境

    1、Java8
    2、其他三方组件清单请参考需求文档中“组件版本”相关内容

### 2.3 需求概述

    见1.4中参考资料


### 2.4 条件与限制

***


## 三、接口设计

### 4.1 模块接口一览表

| **所属用例** | **模块名称**  | **接口**                                  | 接口名称           | 备注         |
| ------------ |  ------------  |     ----------------------------------    |    ------------    | ------------ |
|  | API管理 | /v1/dataService/api/addGroup | 添加接口分组 |  |
|  | API管理 | /v1/dataService/api/addGroup | 修改接口分组 |  |
|  | API管理 | /v1/dataService/api/addGroup | 删除接口分组 |  |
|  | API管理 | /v1/dataService/api/getGroup | 查询接口分组 |  |
|  | API管理 | /v1/dataService/api/listGroup | 查询接口分组列表 |  |
| | API管理 | /v1/dataService/api/listDataSource | 获取数据源列表 | |
| 创建API | API管理       | /v1/dataService/api/addApi | 生成api接口 |              |
| 创建API | API管理 | /v1/dataService/api/eidtApi | 修改接口 | |
| 创建API | API管理 | /v1/dataService/api/deleteApi/ | 删除接口 | |
| 创建API | API管理 | /v1/dataService/api/addAuth | 添加接口授权 | |
| 创建API | API管理 | /v1/dataService/api/editAuth | 修改接口授权 | |
| 创建API | API管理 | /v1/dataService/api/deleteAuth | 删除接口授权 | |
| API发布 | API管理 | /v1/dataService/api/publishApi/ | 发布接口 | |
| API撤销发布 | API管理 | /v1/dataService/api/rescindApi/ | 撤销发布接口 | |
| API测试 | API管理 | /v1/dataService/api/executeApi/ | 接口调用测试 | |
| 注册API | API管理    | /v1/dataService/api/registApi | 注册api接口    |              |
| 查看我创建的API | API管理    | /v1/dataService/api/listMyApi | 查看我创建的Api  |              |
| 查看API市场 | API市场    | /v1/dataService/api/listMarketApi | 查看API市场 |              |
| 查看获得授权的API | API市场    | /v1/dataService/api/listMyAuth | 查看获得授权的API |              |
|  | API市场 | /v1/dataService/api/dataView | 数据预览 | |
| 查看全局概览 | 概览       | /v1/dataService/api/globalView | 获取全局概览     |              |
| 查看我的概览 | 概览       | /v1/dataService/api/myView | 获取我的概览    |              |
|                   | API管理 | /v1/dataService/api/listUsers | 查询系统用户列表 |      |
|                   |              |                               |                 |      |



#### 4.1.2 接口详细设计

##### 4.1.2.1 添加接口分组

-    URL: /{version}/dataService/api/addGroup
-    请求方式： POST
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口分组主键 | int | | id名称,同一系统下不可重复,传0为新增,修改传指定id
name | 接口名称 | String | |
parentid | 父节点id         | int |  |
createdBy | 创建人         | String |  |
updatedBy | 修改人         | String |  |

- 入参示例
```json
{
  "id": 0,
  "name": "分类2",
  "parentId": 0,
  "createdBy":"lxf",
  "updatedBy":"lxf"
}
```

- 返回示例及参数说明

```json
{
  "code": 0,
  "result": true,
  "message": "操作接口分组成功",
  "data": {
    "code": 0,
    "result": true,
    "message": null,
    "data": {
      "id": 9,
      "name": "分类2",
      "parentId": 0,
      "createdBy": "lxf",
      "createdTime": "2021-09-09 14:24:09",
      "updatedBy": "lxf",
      "updatedTime": "2021-09-09 14:24:09",
      "description": null
    }
  }
}
```
- 逻辑说明
``` 
    1、接口分组是树结构,目前仅支持2级结构
    2、根节点的parentid为空,只能有一个根节点
```


- 单元测试

  * 1、参数正常设置，是否成功添加接口分组
  * 2、在存在根节点的情况下再添加一个根节点,系统提示报错
  * 3、非根节点必需存在正确的父节点,否则报错
  
##### 4.1.2.2 修改接口分组

-    URL: /{version}/dataService/api/editGroup
-    请求方式： PUT
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口分组主键 | int | | id名称,同一系统下不可重复,传0为新增,修改传指定id
name | 接口名称 | String | |
parentid | 父节点id         | int |  |
createdBy | 创建人         | String |  |
updatedBy | 修改人         | String |  |
- 入参示例
```json

  "id": 9,
  "name": "分类2",
  "parentid": 0,
  "createdBy":"lxf2",
  "updatedBy":"lxf2"
}
```

- 返回示例及参数说明

```json
{
  "code": 0,
  "result": true,
  "message": "操作接口分组成功",
  "data": {
    "code": 0,
    "result": true,
    "message": null,
    "data": {
      "id": 9,
      "name": "分类2",
      "parentId": 0,
      "createdBy": "lxf2",
      "createdTime": null,
      "updatedBy": "lxf2",
      "updatedTime": "2021-09-09 14:24:45",
      "description": null
    }
  }
}
```
- 逻辑说明
``` 
    1、只允许修改分组的名称不能修改节点的父子关系
```


- 单元测试

  * 1、参数正常设置，是否成功添加接口分组
  

##### 4.1.2.3 删除接口分组

-    URL: /{version}/dataService/api/deleteGroup/{id}
-    请求方式： DELETE
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口分组id | int | |

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/deleteGroup/23
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "message": "删除接口分组成功",
    "result": true
}
```
- 逻辑说明
``` 
   1、接口分组只能从叶子节点删除
   2、接口分组和接口建立关联关系的不可以删除
```


- 单元测试
  
    * 1、正常删除叶子节点的接口分组
    * 2、删除一个非叶子节点的接口分组,提示不能删除
    * 3、删除一个关联了接口叶子节点,提示存在接口关联不能删除

##### 4.1.2.4 查询接口分组

-    URL: /{version}/dataService/api/getGroup/{id}
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口分组id | int | |

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/getGroup/23
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "查询接口分组成功",
    "data": {
        "code": 0,
        "result": true,
        "message": null,
        "data": {
            "id": 15,
            "name": "分类2",
            "parentId": 0,
            "createdBy": "lxf2",
            "createdTime": "2021-09-09 17:52:45",
            "updatedBy": "lxf2",
            "updatedTime": "2021-09-09 17:52:45",
            "description": null
        }
    }
}
```
- 错误实例
```json
{
    "code": 0,
    "result": true,
    "message": "查询接口分组成功",
    "data": {
        "code": -2,
        "result": false,
        "message": "查询接口分组失败,id不存在!"
    }
}
```

- 逻辑说明

``` 
   1、获取单个接口分组
```


- 单元测试
  
    * 1、正常获取单个接口分组

##### 4.1.2.5 查询接口分组列表

-    URL: /{version}/dataService/api/listGroup
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口id | int | |

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/listGroup
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "查询分组列表成功!",
    "data": {
        "content": [
            {
                "id": 15,
                "name": "分类2",
                "parentId": 0,
                "createdBy": "lxf2",
                "createdTime": "2021-09-09 17:52:45",
                "updatedBy": "lxf2",
                "updatedTime": "2021-09-09 17:52:45",
                "description": null
            },
            {
                "id": 12,
                "name": "分类2",
                "parentId": 0,
                "createdBy": "lxf2",
                "createdTime": "2021-09-09 17:52:42",
                "updatedBy": "lxf2",
                "updatedTime": "2021-09-09 17:52:42",
                "description": null
            },
            {
                "id": 11,
                "name": "分类2",
                "parentId": 0,
                "createdBy": "lxf2",
                "createdTime": "2021-09-09 14:55:36",
                "updatedBy": "lxf2",
                "updatedTime": "2021-09-09 14:55:36",
                "description": null
            },
            {
                "id": 10,
                "name": "分类2",
                "parentId": 0,
                "createdBy": "lxf2",
                "createdTime": "2021-09-09 14:55:18",
                "updatedBy": "lxf2",
                "updatedTime": "2021-09-09 14:55:18",
                "description": null
            },
            {
                "id": 9,
                "name": "分类2",
                "parentId": 0,
                "createdBy": "lxf2",
                "createdTime": "2021-09-09 14:24:10",
                "updatedBy": "lxf2",
                "updatedTime": "2021-09-09 14:24:46",
                "description": null
            },
            {
                "id": 8,
                "name": "分类2",
                "parentId": 9,
                "createdBy": "lxf",
                "createdTime": "2021-09-09 14:07:31",
                "updatedBy": "lxf",
                "updatedTime": "2021-09-09 14:55:39",
                "description": null
            }
        ],
        "pageable": {
            "sort": {
                "sorted": true,
                "unsorted": false,
                "empty": false
            },
            "offset": 0,
            "pageNumber": 0,
            "pageSize": 20,
            "unpaged": false,
            "paged": true
        },
        "totalPages": 1,
        "totalElements": 6,
        "last": true,
        "number": 0,
        "size": 20,
        "sort": {
            "sorted": true,
            "unsorted": false,
            "empty": false
        },
        "numberOfElements": 6,
        "first": true,
        "empty": false
    }
}
```
- 逻辑说明
``` 
   1、获取的是全部的接口分组列表
```


- 单元测试
  
    * 1、正常获取接口分组列表并且父子结构完整
    
##### 4.1.2.6 查询数据源列表

-    URL: /{version}/dataService/api/listDataSource
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：


l 参数实例

```json
http://192.168.1.2/v1/dataService/api/listDataSource
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "查询数据源列表成功!",
    "data": {
        "content": [
            {
                "id": 15,
                "name": "icube",
                "datasourceType": "mysql",
                "JdbcConfig" : {
                    "userName": "admin",
                    "password": "123456",
                    "url": "jdbc:mysql://192.168.70.47:3306/icube?useUnicode=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&useSSL=false",
                },
                "tableNames":["api","group","user"],
                "createdBy": "lxf2",
                "createdTime": "2021-09-09 17:52:45",
                "updatedBy": "lxf2",
                "updatedTime": "2021-09-09 17:52:45",
                "description": null
            },
           {
                "id": 16,
                "name": "paas",
                "datasourceType": "sqlserver",
                "JdbcConfig" : {
                    "userName": "admin",
                    "password": "123456",
                    "url": "jdbc:sqlserver://127.0.0.1:1433;databaseName=sales;user=sa;password=123456;selectMethod=cursor;",
                },
                "tableNames":["api","group","user"],
                "createdBy": "lxf2",
                "createdTime": "2021-09-09 17:52:45",
                "updatedBy": "lxf2",
                "updatedTime": "2021-09-09 17:52:45",
                "description": null
            },
            {
                "id": 17,
                "name": "smartdata",
                "datasourceType": "mysql",
                "JdbcConfig" : {
                    "userName": "admin",
                    "password": "123456",
                    "url": "jdbc:mysql://192.168.70.48:3306/smartdata?useUnicode=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&useSSL=false",
                },
                "tableNames":["api","group","user"],
                "createdBy": "lxf2",
                "createdTime": "2021-09-09 17:52:45",
                "updatedBy": "lxf2",
                "updatedTime": "2021-09-09 17:52:45",
                "description": null
            },
           
        ],
        "pageable": {
            "sort": {
                "sorted": true,
                "unsorted": false,
                "empty": false
            },
            "offset": 0,
            "pageNumber": 0,
            "pageSize": 20,
            "unpaged": false,
            "paged": true
        },
        "totalPages": 1,
        "totalElements": 6,
        "last": true,
        "number": 0,
        "size": 20,
        "sort": {
            "sorted": true,
            "unsorted": false,
            "empty": false
        },
        "numberOfElements": 6,
        "first": true,
        "empty": false
    }
}
```
- 逻辑说明
``` 
   1、获取的是全部的接口分组列表
```


- 单元测试
  
    * 1、正常获取接口分组列表并且父子结构完整
    


##### 4.1.2.7 生成api接口

-    URL: /{version}/dataService/api/addApi
-    请求方式： POST
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口主键 | int | | 传存在id代表修改,0代表新增 
name | 接口名称 | String | |
description | 接口说明 | String |  |
path| 接口路径 | String |  |  
overtime | 超时时间 | int    | |超时时间
singleLimit | 调用次数限制 | String ||单用户每秒调用次数限制
protocol | 协议 | String ||HTTP/HTPS
requestType | 请求方式 | String ||支持GET/POST
requestParam | 请求参数 | Json ||请求参数列表
returnType  | 返回类型 | String | |
whiteList | 白名单 | String | |
group | 所属分组 | Json | |
datasource| 数据源 | Json | |支持类型：mysql、sqlserver
page| 是否分页 | bool | |
pageParam| 是否携带分页参数 | bool | |返回结果是否携带分页参数
status| 状态 | String | |0:未发布 1: 已发布
sql| SQL语句 | String | |
userId| 用户id | int |      |

- 入参示例
```json
{
	"id": 0,
	"name": "getOrderList",
	"description": "获取订单列表",
	"path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
	"overtime": 5000,
	"singleLimit": 1000,
	"protocol": "HTTP",
	"requestType": "POST",
    "returnType":"JSON",
	"whiteList": [{
		"id": 1,
		"name": "张三"
	}],
	"groupId": {
		"id": 5,
		"name": "group1"
	},
	"page": 1,
	"pageParam": 1,
	"datasourceId": {
		"id": 3,
		"name": "mysql-db",
		"datasourceType": "mysql",
		"jdbcConfig": {
			"driver": "com.mysql.jdbc.Driver",
			"userName": "admin",
			"password": "123456",
			"url": "jdbc:mysql://localhost:3306/test"
		}
	},
	"sql": "select * from api",
    "dataTable":"api",
    "status": 0,
    "userId": 3,
	"requestParam": [{
		"id": 1,
		"name": "usr",
		"bindField": "age",
		"type": "varchar",
		"operator": "LIKE",
		"requried": 0,
		"defaultValue": "",
		"description": "des"
	}],
    "returnParam" :[{
        "id": 1,
		"name": "usr",
		"bindField": "age",
		"type": "varchar",		
		"description": "des"
    }]
}
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "操作Api成功!",
    "data": {
        "code": 0,
        "result": true,
        "message": null,
        "data": {
            "id": 1,
            "name": "getOrderList",
            "path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
            "description": "获取订单列表",
            "overtime": 5000,
            "singleLimit": 1000,
            "protocol": "HTTP",
            "requestType": "POST",
            "returnType": "JSON",
            "whiteList": "[{\"id\":1,\"name\":\"张三\"}]",
            "groupId": "{\"id\":5,\"name\":\"group1\"}",
            "datasourceId": "{\"id\":3,\"name\":\"mysql-db\",\"datasourceType\":\"mysql\",\"jdbcConfig\":{\"driver\":\"com.mysql.jdbc.Driver\",\"userName\":\"admin\",\"password\":\"123456\",\"url\":\"jdbc:mysql://localhost:3306/test\"}}",
            "page": 1,
            "sourceHost": null,
            "sourcePath": null,
            "pageParam": 1,
            "sql": "select * from api",
            "dataTable": "api",
            "rightCase": null,
            "excepitonCase": null,
            "status": 0,
            "userId": 3,
            "from": null,
            "errorCode": null,
            "createdBy": null,
            "createdTime": "2021-09-10 00:59:46",
            "updatedBy": null,
            "updatedTime": "2021-09-10 00:59:46"
        }
    }
}
```
- 逻辑说明
``` 
     1、从界面构建生成接口的所有参数
     2、分页参数采用全局默认参数不再单独配置
     3、新建接口默认状态:0 未发布
     4、path不可重复
```


- 单元测试

  * 1、参数正常设置，是否成功保存接口
  * 2、参数设置不正常，是否报错


##### 4.1.2.8 修改api接口

-    URL: /{version}/dataService/api/addApi
-    请求方式： POST
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口主键 | int | | 传存在id代表修改,0代表新增 
name | 接口名称 | String | |
description | 接口说明 | String |  |
path| 接口路径 | String |  |  
overtime | 超时时间 | int | |
singleLimit | 调用次数限制 | int ||单用户每秒调用次数限制
protocol | 协议 | String ||HTTP/HTPS
requestType | 请求方式 | String ||支持GET/POST
requestParam | 请求参数 | Json ||请求参数列表
returnType  | 返回类型 | String | |
whiteList | 白名单 | String | |
group | 所属分组 | Json | |
datasource| 数据源 | Json | |支持类型：mysql、sqlserver
page| 是否分页 | bool | |
pageParam| 是否携带分页参数 | bool | |返回结果是否携带分页参数
status| 状态 | String | |0:未发布 1: 已发布
sql| SQL语句 | String | |
userId| 用户id | int |  |

- 入参示例
```json
{
	"id": 1,
	"name": "getOrderList",
	"description": "获取订单列表2",
	"path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
	"overtime": 5000,
	"singleLimit": 1000,
	"protocol": "HTTP",
    "returnType":"JSON",
	"requestType": "POST",
	"whiteList": [{
		"id": 1,
		"name": "张三"
	}],
	"groupId": {
		"id": 5,
		"name": "group1"
	},
	"page": 1,
	"pageParam": 1,
	"datasourceId": {
		"id": 3,
		"name": "mysql-db",
		"datasourceType": "mysql",
		"jdbcConfig": {
			"driver": "com.mysql.jdbc.Driver",
			"userName": "admin",
			"password": "123456",
			"url": "jdbc:mysql://localhost:3306/test"
		}
	},
	"sql": "select * from api",
    "dataTable":"api",
    "status": 0,
    "userId": 3,
	"requestParam": [{
		"id": 1,
		"name": "usr",
		"bindField": "age",
		"type": "varchar",
		"operator": "LIKE",
		"requried": 0,
		"defaultValue": "",
		"description": "des"
	}],
    "returnParam" :[{
        "id": 1,
		"name": "usr",
		"bindField": "age",
		"type": "varchar",		
		"description": "des"
    }]
}
```

- 返回示例及参数说明

```json
{
  "code":0,
  "message":"修改接口成功",
  "result": true
}
```
- 逻辑说明
``` 
     1、编辑时前端id需传值   
     1、只有生成的接口可以修改,注册的接口不可以修改
```
- 单元测试

    * 1、参数正常设置，是否成修改接口
    * 2、参数设置不正常，是否报错

##### 4.1.2.9 删除接口

-    URL: /{version}/dataService/api/deleteApi/{id}
-    请求方式： DELETE
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口id | int | |

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/deleteApi/23
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "删除Api接口成功",
    "data": {
        "code": 0,
        "result": true,
        "message": "删除Api接口成功!"
    }
}
```
- 失败返回
```json
{
    "code": 0,
    "result": true,
    "message": "删除Api接口成功",
    "data": {
        "code": -2,
        "result": false,
        "message": "删除Api接口失败!"
    }
}
```

- 逻辑说明

``` 
   1、此接口参数为接口id
   2、可以删除生成的接口,也可以删除注册的接口
```


- 单元测试
  
    * 1、检查是否可以删除接口

##### 4.1.2.10 添加接口授权

-    URL: /{version}/dataService/api/addAuth
-    请求方式： POST
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口分组主键 | int | | id名称,同一系统下不可重复
apiId | 接口id | long | | 
userId | 用户id | long | |
limitNum | 调用次数       | int |  |调用次数限制
startTime | 开始时间 | Date | |限制调用周期开始时间
endTime | 结束时间 | Date | |限制调用周期结束时间
limit | 是否限制调用次数 | bool | |
limitTime | 是否限制调用周期 | bool | |

- 入参示例
```json
{
    "id":0,
    "apiId": 5,
	"userId": 4,
	"limitNum": 2000,
    "startTime": "2021-09-20 00:00:00",
    "endTime": "2021-10-20 00:00:00",
    "limit":1,
    "limitTime": 0
}
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "接口授权操作成功!",
    "data": {
        "code": 0,
        "result": true,
        "message": "用户授权添加成功!",
        "data": {
            "id": 30,
            "apiId": 5,
            "userId": 4,
            "limitNum": 2000,
            "limit": 1,
            "startTime": "2021-09-20 00:00:00",
            "endTime": "2021-10-20 00:00:00",
            "limitTime": 0,
            "createdBy": null,
            "authTime": null
        }
    }
}





如果第二次授权:

{
    "code": 0,
    "result": true,
    "message": "接口授权操作成功!",
    "data": {
        "code": -2,
        "result": false,
        "message": "该用户已经授权,不可重复授权!"
    }
}


如果apiId不为0(未发布):
{
    "code": 0,
    "result": true,
    "message": "接口授权操作成功!",
    "data": {
        "code": -2,
        "result": false,
        "message": "Api未发布,禁止授权!"
    }
}
```
- 逻辑说明
``` 
    1、授权时要检查是否重复授权,不可一个接口对同一个用户重复授权
    2、未发布的接口不可以授权,一定要是已经发布的接口才可以授权
```


- 单元测试

  * 1、参数正常设置，是否成功添加接口授权
  * 2、重复授权,系统应提示不可以重复授权
  * 3、未发布的接口不可以进行授权
  
##### 4.1.2.11 修改接口授权

-    URL: /{version}/dataService/api/addAuth
-    请求方式： POST
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口分组主键 | int | | id名称,同一系统下不可重复
apiId | 接口id | long | | 
userId | 用户id | long | |
limitNum | 调用次数       | int |  |调用次数限制
startTime | 开始时间 | Date | |限制调用周期开始时间
endTime | 结束时间 | Date | |限制调用周期结束时间
limit | 是否限制调用次数 | bool | |
limitTime | 是否限制调用周期 | bool | |

- 入参示例
```json
{
    "id":34,
    "apiId": 1,
	"userId": 4,
	"limitNum": 1000,
    "startTime": "2021-09-20 00:00:00",
    "endTime": "2021-10-20 00:00:00",
    "limit":1,
    "limitTime": 0
}
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "授权接口操作成功!",
    "data": {
        "code": 0,
        "result": true,
        "message": "用户授权修改成功!",
        "data": {
            "id": 34,
            "apiId": 1,
            "userId": 4,
            "limitNum": 1000,
            "limit": 1,
            "startTime": "2021-09-20 00:00:00",
            "endTime": "2021-10-20 00:00:00",
            "limitTime": 0,
            "createdBy": null,
            "authTime": null
        }
    }
}


如果未授权:(api   status=1):
{
    "code": 0,
    "result": true,
    "message": "授权接口操作成功!",
    "data": {
        "code": -2,
        "result": false,
        "message": "Api未发布,禁止修改!"
    }
}

```
- 逻辑说明
``` 
    1、修改用户时要检查是否存在重复授权
    2、未发布的接口不可以修改授权,一定要是已经发布的接口才可以修改授权
```


- 单元测试

  * 1、参数正常设置，是否成功修改接口授权
  * 2、修改授权用户,该用户已经拥有这个接口的权限,提示不可以重复授权
  * 3、未发布的接口不可以修改授权

##### 4.1.2.12 删除接口授权

-    URL: /{version}/dataService/api/deleteAuth/{id}
-    请求方式： DELETE
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口授权id | int | |
ApiAuthDTO | 实体 | @RequestBody | |

l 参数实例@

```json
http://192.168.1.2/v1/dataService/api/deleteAuth/23
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "删除授权接口操作成功",
    "data": {
        "code": 0,
        "result": true,
        "message": "删除Api接口成功!"
    }
}
```
- 逻辑说明
``` 


{
    "code": 0,
    "result": true,
    "message": "删除授权接口操作成功",
    "data": {
        "code": -2,
        "result": false,
        "message": "Api接口未发布,不可删除授权!"
    }
}


1、未发布的接口授权不可以删除 
```


- 单元测试
  
    * 1、正常删除接口授权

##### 4.1.2.13 发布接口

-    URL: /{version}/dataService/api/publishApi/{id}
-    请求方式： PUT
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/publishApi/23
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "发布接口操作成功",
    "data": {
        "code": 0,
        "result": true,
        "message": "发布Api接口成功!"
    }
}

{
    "code": 0,
    "result": true,
    "message": "发布接口操作成功",
    "data": {
        "code": -2,
        "result": false,
        "message": "接口已经发布,不能重复发布!"
    }
}
```

- 逻辑说明
```
   1、只能发布未发布的接口如果是已经发布的接口后端提示接口已经发布
   2、可以发布生成的接口,也可以发布注册的接口
```

- 单元测试

  * 1、发布一个未发布的接口,看是否能够正常发布成功
  * 2、发布一个已经发布的接口,看是否提示已经发布


##### 4.1.2.14 撤销发布接口

-    URL: /{version}/dataService/api/rescindApi/{id}
-    请求方式： PUT
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/rescindApi/23
```

- 返回示例及参数说明
```json
{
    "code": 0,
    "result": true,
    "message": "撤销发布接口操作成功",
    "data": {
        "code": 0,
        "result": true,
        "message": "撤销发布Api接口成功!"
    }
}

{
    "code": 0,
    "result": true,
    "message": "撤销发布接口操作成功",
    "data": {
        "code": -2,
        "result": false,
        "message": "接口已经撤销,不能重复撤销!"
    }
}
```

- 逻辑说明
```
 1、只能撤销未撤销的接口如果是已经撤销的接口后端提示接口已经撤销
 2、可以撤销发布生成的接口,也可以撤销发布注册的接口
```

- 单元测试
  
   * 1、撤销一个未撤销的接口,看是否能够正常撤销成功
   * 2、撤销一个已经撤销的接口,看是否提示已经撤销

##### 4.1.2.15 接口测试

-    URL: /{version}/dataService/api/executeApi
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/executeApi/{apiName}
```

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
apiName | 接口名称 | String | |  
requestParam | 请求参数 | Json | | 请求参数 

- 入参示例
```json
  {	
	"USER_CODE":1,
    "MOBILE_TEL": "13812321987",
    "ID_EXP_DATE" : 2 
  }
```

- 返回示例及参数说明
```json
{  
  "code":0,
  "message":"接口测试调用成功",
   "data": {
        "listManagement": [
            {
                "endTime": 1234567,
                "startTime": 123456,
                "userName": "zhangsan",
                "id": 1,
                "userId": 1,
                "type":1
            }
        ],
        "total": 1,
        "totalPage": 1,
        "pageNo": 1,
        "pageSize": 20
    },  
}
```

- 逻辑说明
```
 1、path作为测试接口的入参,后台根据path获取接口的实例,再根据参数配置进行实际的接口调用
 2、可以测试生成的接口也可以测试注册的接口,后台根据接口的类型进行自动的处理
 3、这个传入的参数用map接收,根据接口定义的参数从map中取值赋值,无传值有默认值的用默认值,没有默认值的抛出错误提示前端
```

- 单元测试

  * 给定不通的参数值,都能正确的返回测试结果

##### 4.1.2.16 注册api接口

-    URL: /{version}/dataService/api/registApi
-    请求方式： POST
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口主键 | Long | | id名称,同一系统下不可重复
name | 接口名称 | String | |
description | 接口说明 | String |  |
sourceHost | 后端 Hos | String | |
sourcePath | 后端服务 Path | String | |
path| 接口路径 | String |  |  
overtime | 超时时间 | String | |
singleLimit | 调用次数限制 | String ||单用户每秒调用次数限制
protocol | 协议 | String ||HTTP/HTPS
requestType | 请求方式 | String ||支持GET/POST
requestParam | 请求参数 | Json ||请求参数列表
constParam | 常量参数 | Json ||常量参数列表
returnType  | 返回类型 | String | |
whiteList | 白名单 | String | |
group | 所属分组 | Json | |
page| 是否分页 | bool | |
pageParam| 是否携带分页参数 | bool | |返回结果是否携带分页参数
status| 状态 | String | |0:未发布 1: 已发布
userId| 用户id | int | |

- 入参示例
```json
{
	"id": 0,
	"name": "getOrderList",
	"description": "获取订单列表",
    "sourceHost": "http://10.102.127:9040",
    "sourcePath": "/orderService/v1/getOrderList",
	"path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
	"overtime": 5000,
	"singleLimit": 1000,
	"protocol": "HTTP",
	"requestType": "POST",
    "returnType":"JSON",
	"whiteList": [{
		"id": 1,
		"name": "张三"
	}],
	"group": {
		"id": 5,
		"name": "group1"
	},
	"page": 1,
	"pageParam": 1,	
    "status": 0,
    "userId": 3,
	"requestParam": [{
		"id": 1,
		"name": "usr",
        "position":"query",
		"type": "varchar",
		"requried": 0,
		"description": "des"
	}],
    "constParam": [{
		"id": 1,
		"name": "usr",
        "position":"query",
		"type": "varchar",
		"defaultValue": "asd",
		"description": "des"
	}],
    "returnParam" :[{
        "id": 1,
		"name": "usr",
		"bindField": "age",
		"type": "varchar",		
		"description": "des"
    }]
}
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "操作Api成功!",
    "data": {
        "code": 0,
        "result": true,
        "message": null,
        "data": {
            "id": 7,
            "name": "getOrderList",
            "path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
            "description": "获取订单列表",
            "overtime": 5000,
            "singleLimit": 1000,
            "protocol": "HTTP",
            "requestType": "POST",            
            "returnType": "JSON",
            "whiteList": "[{\"id\":1,\"name\":\"张三\"}]",
            "groupId": "null",
            "datasourceId": "null",
            "page": 1,
            "sourceHost": "http://10.102.127:9040",
            "sourcePath": "/orderService/v1/getOrderList",
            "pageParam": 1,
            "querySql": null,
            "dataTable": null,
            "rightCase": null,
            "excepitonCase": null,
            "status": 0,
            "userId": 3,
            "sourceWay": "regist",
            "errorCode": null,
            "createdBy": null,
            "createdTime": "2021-09-10 14:12:49",
            "updatedBy": null,
            "updatedTime": "2021-09-10 14:12:49"
        }
    }
}
```
- 逻辑说明
``` 
     1、从界面构建生成接口的所有参数
     2、分页参数采用全局默认参数不再单独配置
     3、新建接口默认状态:0 未发布
     4、path参数必需全局唯一
```


- 单元测试

  * 1、参数正常设置，是否成功保存接口
  * 2、参数设置不正常，是否报错



##### 4.1.2.17 查看我创建的API

-    URL: /{version}/dataService/api/listMyApi/{userId}/{groupid}
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/getMyApi/23/2
```
- 返回示例及参数说明

```json
{
	"code": 0,
	"message": "获取我创建的接口成功",
	"result": true,
	"data": [{
			"id": 11,
			"name": "getOrderList",
			"description": "获取订单列表",
			"path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
			"overtime": 5000,
			"singleLimit": 1000,
			"protocol": "HTTP",
			"requestType": "POST",
            "returnType":"JSON",
            "lastCall24":29,
            "totalCall": 399,
			"whiteList": [{
				"id": 1,
				"name": "张三"
			}],
			"group": {
				"id": 5,
				"name": "group1"
			},
			"page": false,
			"pageParam": false,
			"dataSource": {
				"id": 3,
				"name": "mysql-db",
				"datasourceType": "mysql",
				"jdbcConfig": {
					"driver": "com.mysql.jdbc.Driver",
					"userName": "admin",
					"passoerd": "123456",
					"url": "jdbc:mysql://localhost:3306/test"
				}
			},
			"sql": "select * from api",
			"dataTable",
			"api",
			"status": 0,
            "userId": 23,
			"requestParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"operator": "LIKE",
				"requried": "true",
				"defaultValue": "",
				"description": "des"
			}],
			"returnParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"description": "des"
			}]
		},
		{
			"id": 12,
			"name": "getOrderList",
			"description": "获取订单列表",
			"path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
			"overtime": 5000,
			"singleLimit": 1000,
			"protocol": "HTTP",
			"requestType": "POST",
            "returnType":"JSON",
			"whiteList": [{
				"id": 1,
				"name": "张三"
			}],
			"group": {
				"id": 5,
				"name": "group1"
			},
			"page": false,
			"pageParam": false,
			"dataSource": {
				"id": 3,
				"name": "mysql-db",
				"datasourceType": "mysql",
				"jdbcConfig": {
					"driver": "com.mysql.jdbc.Driver",
					"userName": "admin",
					"passoerd": "123456",
					"url": "jdbc:mysql://localhost:3306/test"
				}
			},
			"sql": "select * from api",
			"dataTable",
			"api",
			"status": 0,
            "userId": 23,
			"requestParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"operator": "LIKE",
				"requried": "true",
				"defaultValue": "",
				"description": "des"
			}],
			"returnParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"description": "des"
			}]
		}
	]
}
```
- 逻辑说明
``` 
     1、仅获取我创建的接口
     2、仅获取当前选定分组的接口
```


- 单元测试

  * 1、参数正常设置，查看所获接口都是我创建的接口
  * 2、参数正常设置，查看所获接口都是当前选定分组的接口

##### 4.1.2.18 查看API市场

-    URL: /{version}/dataService/api/listMarketApi/
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/listMarketApi
```
- 返回示例及参数说明

```json
{
	"code": 0,
	"message": "获取我的API市场成功",
	"result": true,
	"data": [{
			"id": 10,
			"name": "getOrderList",
			"description": "获取订单列表",
			"path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
			"overtime": 5000,
			"singleLimit": 1000,
			"protocol": "HTTP",
            "from":"create",           
			"requestType": "POST",
            "returnType":"JSON",
            "totalCall": 399,
			"whiteList": [{
				"id": 1,
				"name": "张三"
			}],
			"group": {
				"id": 5,
				"name": "group1"
			},
			"page": false,
			"pageParam": false,
			"dataSource": {
				"id": 3,
				"name": "mysql-db",
				"datasourceType": "mysql",
				"jdbcConfig": {
					"driver": "com.mysql.jdbc.Driver",
					"userName": "admin",
					"passoerd": "123456",
					"url": "jdbc:mysql://localhost:3306/test"
				}
			},
			"sql": "select * from api",
			"dataTable",
			"api",
			"status": 0,
            "userId": 23,
			"requestParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"operator": "LIKE",
				"requried": "true",
				"defaultValue": "",
				"description": "des"
			}],
			"returnParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"description": "des"
			}]
		},
		{
			"id": 13,
			"name": "getOrderList",
			"description": "获取订单列表",
			"path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
			"overtime": 5000,
			"singleLimit": 1000,
			"protocol": "HTTP",
            "from":"regist",
            "createdBy": "3",
			"requestType": "POST",
            "returnType":"JSON",
			"whiteList": [{
				"id": 1,
				"name": "张三"
			}],
			"group": {
				"id": 5,
				"name": "group1"
			},
			"page": false,
			"pageParam": false,
			"dataSource": {
				"id": 3,
				"name": "mysql-db",
				"datasourceType": "mysql",
				"jdbcConfig": {
					"driver": "com.mysql.jdbc.Driver",
					"userName": "admin",
					"passoerd": "123456",
					"url": "jdbc:mysql://localhost:3306/test"
				}
			},
			"sql": "select * from api",
			"dataTable",
			"api",
			"status": 0,
            "userId": 23,
			"requestParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"operator": "LIKE",
				"requried": "true",
				"defaultValue": "",
				"description": "des"
			}],
			"returnParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"description": "des"
			}]
		}
	]
}
```
- 逻辑说明
``` 
     1、api市场包含了全部的api 
     2、接口的白名单用户也可以进行接口的测试调用
```


- 单元测试

  * 1、参数正常设置，验证是否正确的获取三类接口

##### 4.1.2.19 查看我授权的API

-    URL: /{version}/dataService/api/listMyAuth/{userId}
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/listMyAuth/23
```
- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "查看API市场接口操作成功!",
    "data": {
        "code": 0,
        "result": true,
        "message": null,
        "data": [
            {
                "id": 1,
                "name": "getOrderList",
                "path": "http://192.168.2.12:8011/orderService/v1/getOrderList",
                "description": "获取订单列表2",
                "overtime": 5000,
                "singleLimit": 1000,
                "protocol": "HTTP",
                "requestType": "POST",
                "returnType": null,
                "whiteList": "[{\"id\":1,\"name\":\"张三\"}]",
                "groupId": "{\"id\":4,\"name\":\"group1\"}",
                "datasourceId": "{\"id\":3,\"name\":\"mysql-db\",\"datasourceType\":\"mysql\",\"jdbcConfig\":{\"driver\":\"com.mysql.jdbc.Driver\",\"userName\":\"admin\",\"password\":\"123456\",\"url\":\"jdbc:mysql://localhost:3306/test\"}}",
                "page": 1,
                "sourceHost": null,
                "sourcePath": null,
                "pageParam": 1,
                "querySql": "select * from api",
                "dataTable": "api",
                "rightCase": null,
                "excepitonCase": null,
                "status": 1,
                "userId": 4,
                "sourceWay": null,
                "errorCode": null,
                "createdBy": null,
                "createdTime": "2021-09-10 00:59:46",
                "updatedBy": null,
                "updatedTime": "2021-09-14 10:12:56"
            }
        ]
    }
}







{
    "code": 0,
    "result": true,
    "message": "查看API市场接口操作成功!",
    "data": {
        "code": -2,
        "result": false,
        "message": "查询接口分组失败,userId不存在!"
    }
}






```
- 逻辑说明
``` 
     1、需要关联api_auth表进行查询,仅获取我授权的接口
```


- 单元测试

  * 1、参数正常设置，验证是否正确的获取我授权的接口

##### 4.1.2.20 数据预览

-    URL: /{version}/dataService/api/dataView/{apiId}/{userId}
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/dataView/2/3
```
- 返回示例及参数说明

```json
{
	"code": 0,
	"message": "获取数据预览成功",
	"result": true,
	"data": {
		"apiId": 5,
        "path":"http://192.168.2.12:8011/orderService/v1/getOrderList",
        "requestType": "POST",
		"returnType":"JSON",
        "callAuth": false,
        "requestParam": [{
				"id": 1,
				"name": "usr",
				"bindField": "age",
				"type": "varchar",
				"operator": "LIKE",
				"requried": "true",
				"value": ""				
			}]
	}
}
```
- 逻辑说明
``` 
     1、后台根据接口id及用户id进行判断该接口是否是用户的创建者,授权者,以及是否是白名单用户,如果符合这三个条件的callAuth为true否则为false
```


- 单元测试

  * 1、正确返回结果数据


##### 4.1.2.21 获取全局概览

-    URL: /{version}/dataService/api/globalView
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/globalView
```
- 返回示例及参数说明

```json
{
	"code": 0,
	"message": "获取全局概览成功",
	"result": true,
	"data": {
		"totalCall": 120,
		"fail": "2",
		"totalApi": 500,
		"userTop": [{
				"userName": "zhangs",
				"callNum": 20
			}, {
				"userName": "lisi",
				"callNum": 24
			},
			{
				"userName": "wangwu",
				"callNum": 10
			}, {
				"userName": "tom",
				"callNum": 23
			},
			{
				"userName": "kaite",
				"callNum": 25
			}
		],
		"callTop": [{
				"apiName": "interface1",
				"callNum": 20
			}, {
				"apiName": "interface2",
				"callNum": 24
			},
			{
				"apiName": "interface3",
				"callNum": 10
			}, {
				"apiName": "interface4",
				"callNum": 23
			},
			{
				"apiName": "interface5",
				"callNum": 25
			}
		],
		"failTop": [{
				"apiName": "interface1",
				"failNum": 20,
				"failRate": 0.1
			},
			{
				"apiName": "interface2",
				"failNum": 24,
				"failRate": 0.5
			},
			{
				"apiName": "interface3",
				"failNum": 10,
				"failRate": 0.3
			},
			{
				"apiName": "interface4",
				"failNum": 23,
				"failRate": 0.2
			},
			{
				"apiName": "interface5",
				"failNum": 25,
				"failRate": 0.1
			}
		],
		"errorType": [{
				"typeName": "禁用",
				"errorNum": 12
			},
			{
				"typeName": "未认证",
				"errorNum": 13
			},
			{
				"typeName": "参数错误",
				"errorNum": 16
			},
			{
				"typeName": "超时",
				"errorNum": 12
			},
			{
				"typeName": "超出限制",
				"errorNum": 11
			},
			{
				"typeName": "其他",
				"errorNum": 10
			}
		]
	}
}
```
- 逻辑说明
``` 
     1、后台进行综合加工处理返回界面所需的所有结果数据,统计的是所有的接口数据
```


- 单元测试

  * 1、正确返回结果数据

##### 4.1.2.22 获取我的概览

-    URL: /{version}/dataService/api/myView/{userId}
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/myView/23
```
- 返回示例及参数说明

```json
{
	"code": 0,
	"message": "获取我的概览成功",
	"result": true,
	"data": {
		"totalCall": 120,
		"fail": "2",
		"totalApi": 500,
		"userTop": [{
				"userName": "zhangs",
				"callNum": 20
			}, {
				"userName": "lisi",
				"callNum": 24
			},
			{
				"userName": "wangwu",
				"callNum": 10
			}, {
				"userName": "tom",
				"callNum": 23
			},
			{
				"userName": "kaite",
				"callNum": 25
			}
		],
		"callTop": [{
				"apiName": "interface1",
				"callNum": 20
			}, {
				"apiName": "interface2",
				"callNum": 24
			},
			{
				"apiName": "interface3",
				"callNum": 10
			}, {
				"apiName": "interface4",
				"callNum": 23
			},
			{
				"apiName": "interface5",
				"callNum": 25
			}
		],
		"failTop": [{
				"apiName": "interface1",
				"failNum": 20,
				"failRate": 0.1
			},
			{
				"apiName": "interface2",
				"failNum": 24,
				"failRate": 0.5
			},
			{
				"apiName": "interface3",
				"failNum": 10,
				"failRate": 0.3
			},
			{
				"apiName": "interface4",
				"failNum": 23,
				"failRate": 0.2
			},
			{
				"apiName": "interface5",
				"failNum": 25,
				"failRate": 0.1
			}
		],
		"errorType": [{
				"typeName": "禁用",
				"errorNum": 12
			},
			{
				"typeName": "未认证",
				"errorNum": 13
			},
			{
				"typeName": "参数错误",
				"errorNum": 16
			},
			{
				"typeName": "超时",
				"errorNum": 12
			},
			{
				"typeName": "超出限制",
				"errorNum": 11
			},
			{
				"typeName": "其他",
				"errorNum": 10
			}
		]
	}
}
```
- 逻辑说明
``` 
     1、后台进行综合加工处理返回界面所需的所有结果数据,统计的是我的接口及我授权的接口数据
```


- 单元测试

  * 1、正确返回结果数据

##### 4.1.2.23 查询系统用户列表

-    URL: /{version}/dataService/api/listUsers
-    请求方式： GET
-    请求头（Content-Type）：
-    断言：
-    入参实例或参数说明

参数名 | 含义 | 类型 | 长度 | 说明
---|---|---|---|---
id | 接口id | int | |

l 参数实例

```json
http://192.168.1.2/v1/dataService/api/listUsers
```

- 返回示例及参数说明

```json
{
    "code": 0,
    "result": true,
    "message": "查询系统用户列表成功!",
    "data": {
        "content": [
            {
                "id": 1,
                "name": "admin"               
            },
            {
                "id": 12,
                "name": "asd"
            },
            {
                "id": 11,
                "name": "lisi"
            },
            {
                "id": 10,
                "name": "wangwu"
            }
        ],
        "pageable": {
            "sort": {
                "sorted": true,
                "unsorted": false,
                "empty": false
            },
            "offset": 0,
            "pageNumber": 0,
            "pageSize": 20,
            "unpaged": false,
            "paged": true
        },
        "totalPages": 1,
        "totalElements": 6,
        "last": true,
        "number": 0,
        "size": 20,
        "sort": {
            "sorted": true,
            "unsorted": false,
            "empty": false
        },
        "numberOfElements": 6,
        "first": true,
        "empty": false
    }
}
```
- 逻辑说明
``` 
   1、获取的是全部的接口分组列表
```


- 单元测试
  
    * 1、正常获取接口分组列表并且父子结构完整

## 五、权限管理和限流

###5.1 使用GateWay进行权限控制

GateWay作为网关路由是挡在了我们的系统最前边，进行动态路由配置和转发。那么我们就可以在网关层进行网关鉴权。

以下代码是一个实现鉴权过滤的伪代码

```java
@Component 
public class ApiAuthFilter implements GlobalFilter, Ordered {

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {

        /*
        这个request对象可以获取更多的内容
       比如，如果是使用token验证的话，就可以判断它的Header中的Token值了
       为了演示方便，我就判断了它的参数
         */
        ServerHttpRequest request = exchange.getRequest();
        MultiValueMap<String, String> queryParams = request.getQueryParams();
        String path = queryParams.getFirst("path");
        //根据上下文获取当前用户 判断当前用户是否具有path所在接口的执行权限,包括接口创建者,授权者及白名单用户
        if (不符合条件) {

            //不允许访问，禁止访问
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode(HttpStatus.NOT_ACCEPTABLE); //这个状态码是406
            return exchange.getResponse().setComplete();
        }
        //符合条件的放行
        return chain.filter(exchange);
    }

    /**
     * 这是Ordered接口的中的方法
     * 过滤器有一个优先级的问题，这个值越小，优先级越高
     * @return
     */
    @Override
    public int getOrder() {
        return 0;
    }
}
```

###5.2 使用Sentinel进行限流控制

**Sentinel是阿里开源的项目，提供了流量控制，熔断降级，系统负载包含等多个维度来保障服务之间的稳定性。**

以下代码是一个实现接口限流的伪代码

```java
//限流规则定义   
private void initFlowQpsRule() {
        List<FlowRule> rules = new ArrayList<>();
        FlowRule rule = new FlowRule("/testA");
        //限制每秒调用2000次
        rule.setCount(2000);
        rule.setGrade(RuleConstant.FLOW_GRADE_QPS);
        rule.setLimitApp("default");
        rules.add(rule);
}

    //限流资源定义
    @GetMapping("/testA")
    @SentinelResource(value = "testA", blockHandler = "deal_testHotKey")
    public String testA(@RequestParam(value = "userId", required = false)Integer userId,do
                             @RequestParam(value = "path", required = false)String path) {
        
        return "正常执行接口调用返回结果";
    }

    //超过限流上限执行这个方法
    public String deal_testHotKey(String p1, String p2, BlockException exception) {        
        return "接口每秒调用次数超过了设定的上限";
    }
```






## 六、数据结构设计

### 6.1 逻辑结构设计

### ![image-20210419080704766](_images/api_service.png)

### 6.2 数据库表设计

- 表名称 : api_group
- 表中文名: 接口分组

| 列名 | 数据类型 | 长度 | 是否可为空 | 默认值 | 注释         | 列备注信息 |
| --------------- | -------- | ---- | ------------------- | ------ | ------------ | ------------------------------------------------------------ |
| id              | int      | 11   | no|        | 主键ID       | |
| name    | varchar  | 128 | no                 |        | 接口分组名称 |     |
| parentid | int  | 11 | yes               |        | 父节点id | |
| description | varchar | 500 | yes |        | 节点描述 | |
| created_by | varchar | 255 | no                 |        | 创建者  |  |
| created_time | datetime |      | no |  | 创建时间     |  |
| updated_by | varchar      | 225   | no                 |        | 更新者    |  |
| updated_time | datetime | 225   | no                 |        | 更新时间 |  |

***

- 表名称 : api
- 表中文名: 接口

| 列名 | 数据类型 | 长度 | 是否可为空 | 默认值 | 注释         | 列备注信息 |
| --------------- | -------- | ---- | ------------------- | ------ | ------------ | ------------------------------------------------------------ |
| id              | int      | 11   | no|        | 主键ID       | |
| name    | varchar  | 128 | no                 |        | 接口名称 |     |
| path | varchar | 500 | yes               |        | 请求路径 | |
| description | varchar | 500 | yes |        | 接口描述 | |
| overtime | int | 10 | no |        | 调用超时时间(秒) | |
| single_limit | int | 10 | no | | 单用户每秒调用次数限制 | |
| protocol | varchar | 50 | no | | 协议 | |
| request_type | varchar | 50 | no | | 请求方式 | |
| return_type | varchar | 50 | no | | 返回类型 | |
| white_list | varchar | 1000 | yes | | 白名单 | |
| group_id | int | 10 | no | | 所属分组 | |
| data_source_id | int | 10 | yes | | 数据源id | |
| page | tinyint | 1 | no | | 是否分页 | |
| source_host | varchar | 255 | yes | | 后端 Host | |
| source_path | varchar | 255 | yes | | 后端路径 | |
| page_param | tinyint | 1 | no | | 返回结果是否携带分页参数 | |
| query_sql | varchar | 1000 | yes | | sql语句 | |
| data_table | varchar | 255 | yes | | 表名 | |
| right_case | varchar | 1500 | yes | | 正常结果返回示例 | |
| excepiton_case | varchar | 1500 | yes | | 异常结果返回示例 | |
| status | varchar | 20 | no         | | 状态 0:未发布 1: 已发布 | |
| user_id | int | 10 | no | | 用户id,接口生成者或注册者 | |
| source_way | varchar  | 20 | no | | 接口来源 :create 生成  regist注册 | |
| error_code | varchar | 1500 | yes | | 错误码定义 | |
| created_by | varchar | 255 | no                 |        | 创建者  |  |
| created_time | datetime | 0 | no |  | 创建时间     |  |
| updated_by | varchar      | 225   | no                 |        | 更新者    |  |
| updated_time | datetime | 225   | no                 |        | 更新时间 |  |

***


- 表名称 : api_auth
- 表中文名: 接口权限

| 列名 | 数据类型 | 长度 | 是否可为空 | 默认值 | 注释         | 列备注信息 |
| --------------- | -------- | ---- | ------------------- | ------ | ------------ | ------------------------------------------------------------ |
| id              | int      | 11   | no|        | 主键ID       | |
| api_id | bigint | 30 | no                 |        | 接口id |     |
| user_id | int  | 11 | yes               |        | 授权用户 | |
| limit_num | varchar | 20 | no |        | 调用次数限制 | |
| limit | tinyint | 1 | no | | 是否限制调用次数 | |
| start_time | datetime | 0 | yes | | 开始限制时间 | |
| end_time | datetime | 0 | yes | | 结束限制时间 | |
| limit_time | inyint | 1 | yes | | 是否限制调用周期 | |
| created_by | varchar | 255 | no                 |        | 创建者  |  |

***


- 表名称 : api_call
- 表中文名: 接口调用

| 列名 | 数据类型 | 长度 | 是否可为空 | 默认值 | 注释         | 列备注信息 |
| --------------- | -------- | ---- | ------------------- | ------ | ------------ | ------------------------------------------------------------ |
| id              | int      | 11   | no|        | 主键ID       | |
| api_id | bigint |      | no                 |        | 接口id |     |
| call_time | int  | 11 | yes               |        | 调用时间 | |
| duration | varchar | 500 | no |        | 耗时 | |
| request_param | varchar | 1500 | yes | | 请求参数 | |
| result | text | 0 | yes | | 返回结果 | |
| caller | varchar | 50 | yes | | 调用者 | |
| success | tinyint | 1 | no | | 是否调用成功 | |
| error_type | varchar | 20 | yes | | 错误类型 | |
| created_by | varchar | 255 | no                 |        | 创建者  |  |
| created_time | datetime |      | no |  | 创建时间     |  |
| updated_by | varchar      | 225   | no                 |        | 更新者    |  |
| updated_time | datetime | 225   | no                 |        | 更新时间 |  |

***



- 表名称 : api_regist
- 表中文名: 接口注册

| 列名 | 数据类型 | 长度 | 是否可为空 | 默认值 | 注释         | 列备注信息 |
| --------------- | -------- | ---- | ------------------- | ------ | ------------ | ------------------------------------------------------------ |
| id              | int      | 11   | no|        | 主键ID       | |
| api_id | bigint | 20 | no               |        | 接口id | |
| regist_time | datetime | 0    | no |        | 注册时间 | |
| register | varchar      | 225   | no                 |        | 注册人 |  |

***



- 表名称 : const_param
- 表中文名: 常量参数

| 列名 | 数据类型 | 长度 | 是否可为空 | 默认值 | 注释         | 列备注信息 |
| --------------- | -------- | ---- | ------------------- | ------ | ------------ | ------------------------------------------------------------ |
| id              | int      | 11   | no|        | 主键ID       | |
| api_id | bigint | 20 | no              |        | 接口id | |
| name | varchar | 255 | no | | 参数名称 | |
| position | varchar | 50 | no | | 参数位置 | |
| type | varchar | 50 | no | | 数据类型 | |
| default_value | varchar | 255 | yes | | 默认值 | |
| description | varchar | 500 | yes |        | 节点描述 | |

***

- 表名称 : request_param
- 表中文名: 接口请求参数

| 列名 | 数据类型 | 长度 | 是否可为空 | 默认值 | 注释         | 列备注信息 |
| --------------- | -------- | ---- | ------------------- | ------ | ------------ | ------------------------------------------------------------ |
| id              | int      | 11   | no|        | 主键ID       | |
| name    | varchar  | 128 | no                 |        | 参数名称 |     |
| position | varchar | 50 | yes               |        | 参数位置 | |
| bind_field | varchar | 50 | no |        | 节点描述 | |
| type | varchar | 50 | no | | 字段类型 | |
| operator | varchar | 20 | no | | 操作符 | |
| requried | tinyint | 1 | no | | 是否必需 | |
| default_value | varchar | 255 | yes | | 默认值 | |
| description | varchar | 1000 | yes | | 描述 | |
| api_id | bigint | 20 | no | | 接口id | |
| created_by | varchar | 255 | no                 |        | 创建者  |  |
| created_time | datetime | 0 | no |  | 创建时间     |  |
| updated_by | varchar      | 225   | no                 |        | 更新者    |  |
| updated_time | datetime | 0   | no                 |        | 更新时间 |  |

***

- 表名称 : return_param
- 表中文名: 接口返回参数

| 列名 | 数据类型 | 长度 | 是否可为空 | 默认值 | 注释         | 列备注信息 |
| --------------- | -------- | ---- | ------------------- | ------ | ------------ | ------------------------------------------------------------ |
| id              | int      | 11   | no|        | 主键ID       | |
| name    | varchar  | 128 | no                 |        | 参数名称 |     |
| api_id | bigint | 11 | yes               |  | 接口id   | |
| description | varchar | 500 | yes |        | 参数描述 | |
| bind_field | varchar | 50 | no | | 绑定字段 | |
| type | varchar | 50 | yes | | 字段类型 | |
| created_by | varchar | 255 | no                 |        | 创建者  |  |
| created_time | datetime | 0 | no |  | 创建时间     |  |
| updated_by | varchar      | 225   | no                 |        | 更新者    |  |
| updated_time | datetime | 0   | no                 |        | 更新时间   |  |

***


## 七、运行设计

### 7.1 运行模块组合

### 7.2 运行控制

### 7.3 运行时间

***

## 八、出错处理设计

### 8.1 出错输出信息

### 8.2 出错处理对策

    【如设置后备、性能降级、恢复及再启动等。】

***

## 九、安全保密设计

***

## 十、维护设计

    【说明为方便维护工作的设施，如维护模块等。】