package com.zorkdata.apiservice.domain.repository;

import com.zorkdata.apiservice.domain.domain.ApiAuth;
import com.zorkdata.apiservice.domain.dto.ApiAuthDTO;
import io.swagger.models.auth.In;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title: ApiServiceAuthRepository
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/10 010-1:35
 */
public interface ApiAuthRepository extends JpaRepository<ApiAuth, Integer>, JpaSpecificationExecutor<ApiAuth> {
    /**
     * 非空判断,查询该id是否存在
     *
     * @param userId
     * @param apiId
     * @return
     */
    @Query(value = "select count(*) from api_auth where user_id= ?1 and api_id = ?2", nativeQuery = true)
    Integer selectUserId(Integer userId, Integer apiId);

    /**
     * 查看api发布状态
     *
     * @param apiId
     * @return
     */
    @Query(value = "select status from api where id= ?1", nativeQuery = true)
    Integer selectApiStatus(Integer apiId);

    /**
     * 获取api_id
     *
     * @param id
     * @return
     */
    @Query(value = "select api_id from api_auth where id= ?1", nativeQuery = true)
    Integer selectApiId(Integer id);


    /**
     * 根据apiId查询
     *
     * @param apiId
     * @return
     */
    @Query(value = "select user_id from api_auth where api_id= ?1", nativeQuery = true)
    List<Integer> findByApiId(Integer apiId);

    /**
     * 根据apiId,查询对应的apiAuth信息
     *
     * @param apiId
     * @return
     */
    @Query(value = "select start_time , end_time from api_auth where api_id= ?1 and user_id = ?2", nativeQuery = true)
    Map<Date, Date> findApiAuthByApiId(Integer apiId , Integer userid);
}
