package com.zorkdata.apiservice.gateway.schedule;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.Refill;
import io.github.bucket4j.local.LocalBucket;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.configurationprocessor.json.JSONArray;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.time.Duration;

/**
 * @author zyw
 * @create 2021-10-09-13:38
 */
@Component
@EnableScheduling
@Slf4j
public class RefreshApiLimitSchedule {

    @Autowired
    private RestTemplate restTemplate;

    @Value("${api-service-address.url}")
    private String url;


    /**
     * 添加定时任务
     * 每小时执行一次
     */
    @Scheduled(cron = "0 0 0/1 * * ?")
    @PostConstruct
    private void refreshTask() {


        String queryResult = restTemplate.getForObject(url, String.class);
        try {
            JSONObject jo = new JSONObject(queryResult);
            JSONArray data = jo.getJSONArray("data");
            for (int i = 0; i < data.length(); i++) {
                JSONObject o = (JSONObject) data.get(i);

                String name = o.get("name").toString();
                Integer singleLimit = Integer.parseInt(o.get("single_limit").toString());
                //桶的最大容量，即能装载 Token 的最大数量
                int capacity = singleLimit;
                //每次 Token 补充量
                int refillTokens = singleLimit;
                //补充 Token 的时间间隔
                Duration duration = Duration.ofSeconds(1);
                Refill refill = Refill.greedy(refillTokens, duration);
                Bandwidth limit = Bandwidth.classic(capacity, refill);

                LocalBucket bucket = Bucket4j.builder().addLimit(limit).build();
                ApiLimitCache.BUCKET_CACHE.put(name, bucket);

            }

        } catch (JSONException e) {
            e.printStackTrace();
        }


    }
}
