package com.zorkdata.apiservice.common.api.feign;

import com.onlyone.paas.common.core.constant.SecurityConstants;
import com.zorkdata.apiservice.common.api.feign.factory.RemoteAuthCenterServiceFallbackFactory;
import com.zorkdata.apiservice.common.api.feign.factory.RemoteSmartServiceFallbackFactory;
import com.zorkdata.dddlib.core.sdk.InvokeResult;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @title: RemoteSmartService
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/9 009-14:34
 */
@FeignClient(value = "smartdata", fallbackFactory = RemoteSmartServiceFallbackFactory.class)
public interface RemoteSmartService {
    /**
     * 注册系统信息
     *
     * @param page
     * @param size
     * @param namespaceId
     * @param from
     * @return
     */
    @GetMapping("/restful/v1/openDsDataSource/queryDsDatasourceList")
    InvokeResult queryDatasourceList(@RequestParam(value = "page") Integer page,
                                       @RequestParam(value = "size") Integer size,
                                       @RequestParam(value = "namespaceId", required = true) Integer namespaceId,
                                       @RequestHeader(SecurityConstants.FROM) String from);

}
