

/*
 *  Copyright (c) 2019.  ZorkData ICube
 */

package com.zorkdata.apiservice;

import com.onlyone.paas.common.security.service.PigUser;
import com.onlyone.paas.common.security.util.SecurityUtils;
import com.zorkdata.apiservice.config.bean.UserWapper;
import com.zorkdata.dddlib.api.login.model.BkUser;
import com.zorkdata.dddlib.core.GlobalConsts;
import com.zorkdata.dddlib.sdk.web.filter.util.FilterUtil;
import com.zorkdata.dddlib.utils.http.CookieUtil;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * 所有Restful接口都要继承这个父类，保证rest的路径是以/rest开头
 *
 * @author: googe (<a href="mailto:gujunling@zorkdata.com.cn">gujunling@zorkdata.com.cn</a>)
 * @date: 2020/2/26
 */
@SuppressWarnings({"unused"})
public abstract class BaseController {

    @Autowired
    protected HttpSession session;


    @Autowired
    protected HttpServletRequest request;


    /**
     * 读取 当前用户
     *
     * @return
     */
    protected BkUser getUser() {
        PigUser pigUser = SecurityUtils.getUser();
        return new UserWapper(pigUser);
    }
    /**
     * 读取 当前用户id
     *
     * @return
     */
    protected Integer getUserId() {
        PigUser pigUser = SecurityUtils.getUser();
        return pigUser.getId();
    }

    /**
     * 取当前用户登录态token
     *
     * @return
     */
    protected String getBkToken() {
        return CookieUtil.getCookieValue(request, GlobalConsts.C_BK_TOKEN);
    }

    /**
     * 取用户设置的语言
     *
     * @return string
     */
    protected String getUserLang() {
        return FilterUtil.getSessionAttribute(session, GlobalConsts.SYS_LANGUAGE, String.class);
    }

}
