package com.zorkdata.apiservice.facade.impl;

import com.zorkdata.apiservice.application.application.ApiApplication;
import com.zorkdata.apiservice.application.dbutils.MysqlDataType;
import com.zorkdata.apiservice.application.dbutils.SqlServerDataType;
import com.zorkdata.apiservice.common.api.feign.RemoteAuthCenterService;
import com.zorkdata.apiservice.domain.domain.Api;
import com.zorkdata.apiservice.domain.domain.ApiAuth;
import com.zorkdata.apiservice.domain.domain.ApiGroup;
import com.zorkdata.apiservice.domain.dto.ApiAuthDTO;
import com.zorkdata.apiservice.domain.dto.ApiDTO;
import com.zorkdata.apiservice.domain.dto.ApiGroupDTO;
import com.zorkdata.apiservice.facade.facade.ApiFacade;
import com.zorkdata.dddlib.core.sdk.InvokeResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author:changjiazhuang
 * @create:2021/9/3
 */

@Service
@Slf4j
public class ApiServicueFacadeImpl implements ApiFacade {

    @Resource
    RemoteAuthCenterService remoteAuthCenterService;

    @Autowired
    ApiApplication apiApplication;

    @Autowired
    ApiFacade apiFacade;


    @Override
    public InvokeResult listAllUser() {
        return apiApplication.listAllUser();
    }

    @Override
    public InvokeResult queryDatasourceList() {
        return apiApplication.queryDatasourceList();
    }

    @Override
    public InvokeResult addGroup(ApiGroupDTO apiGroupDTO, String username) {
        ApiGroup apiGroup;
        InvokeResult invokeResult;
        try {
            InvokeResult addGroup = apiApplication.addGroup(apiGroupDTO, username);
            invokeResult = InvokeResult.success();
            invokeResult.setData(addGroup);
        } catch (Exception e) {
            log.error("保存接口分组失败", e);
            invokeResult = InvokeResult.fail();
            invokeResult.setMessage("保存接口分组失败" + e.getMessage());
        }
        return invokeResult;
    }

    @Override
    public InvokeResult deleteGroup(Integer id) {
        return apiApplication.deleteGroup(id);
    }

    @Override
    public InvokeResult getGroup(Integer id) {
        return apiApplication.getGroup(id);
    }

    @Override
    public InvokeResult listGroup(String keyword, Integer pageSize, Integer pageNo, String sortField, String sortType) {
        Page<ApiGroup> apiGroups = apiApplication.listGroup(keyword, pageSize, pageNo, sortField, sortType);
        return InvokeResult.success(apiGroups, "查询分组列表成功!");
    }

    @Override
    public InvokeResult addApi(ApiDTO apiDTO, String username, Integer userid) {
        InvokeResult invokeResult;
        try {
            invokeResult = InvokeResult.success();
            apiApplication.addApi(apiDTO, username, userid);
            invokeResult.setMessage("api生成成功!");
        } catch (Exception e) {
            log.error("Api生成失败", e);
            invokeResult = InvokeResult.fail();
            invokeResult.setMessage("Api生成失败" + e.getMessage());
        }
        return invokeResult;
    }

    @Override
    public InvokeResult deleteApi(Integer id) {
        return apiApplication.deleteApi(id);
    }

    @Override
    public InvokeResult addAuth(ApiAuthDTO apiAuthDTO, String username) {
        ApiAuth apiAuth;
        InvokeResult invokeResult = null;
        Integer id = apiAuthDTO.getId();
        try {
            //查看用户是否已经授权 0未授权  1 授权
            Integer count = apiApplication.selectUserId(apiAuthDTO);
            //查看api是否发布 0未发布  1发布
            Integer status = apiApplication.selectApiStatus(apiAuthDTO);
            //如果userid(count)查出来为0,说明该用户未授权,可以进行授权,如果不为0说明已经授权,不可再授权
            if (status.equals(1)) {
                if (count.equals(0)) {
                    //count为0,id为0代表新增
                    apiAuth = apiApplication.addAuth(apiAuthDTO, username);
                    invokeResult = InvokeResult.success("用户授权添加成功!");
                    invokeResult.setData(apiAuth);
                } else {
                    //如果count不为0,说明要不是修改,要不就是已经授权了,进行判断
                    //1.如果id为0,说明此时代表新增时,count>0,说明已经授权了
                    if (id.equals(0)) {
                        log.debug("该用户已经授权,不可重复授权!");
                        invokeResult = InvokeResult.fail();
                        invokeResult.setMessage("该用户已经授权,不可重复授权!");
                    } else {
                        if (status.equals(1)) {
                            //2.如果id = 1  说明此时进行修改操作
                            apiAuth = apiApplication.addAuth(apiAuthDTO, username);
                            invokeResult = InvokeResult.success("用户授权修改成功!");
                            invokeResult.setData(apiAuth);
                        } else {
                            log.debug("Api未发布,禁止修改!");
                            invokeResult = InvokeResult.fail();
                            invokeResult.setMessage("Api未发布,禁止修改!");
                        }
                    }
                }
            } else {
                if (count == 0) {
                    log.debug("Api未发布,禁止授权!");
                    invokeResult = InvokeResult.fail();
                    invokeResult.setMessage("Api未发布,禁止授权!");
                } else {
                    log.debug("Api未发布,禁止修改!");
                    invokeResult = InvokeResult.fail();
                    invokeResult.setMessage("Api未发布,禁止修改!");
                }
            }
        } catch (Exception e) {
            log.error("接口授权操作失败!", e);
            invokeResult = InvokeResult.fail();
            invokeResult.setMessage("接口授权操作失败!" + e.getMessage());
        }
        return invokeResult;
    }

    @Override
    public InvokeResult deleteAuth(Integer id) {
        InvokeResult invokeResult;
        try {
            invokeResult = apiApplication.deleteAuth(id);
        } catch (Exception e) {
            log.error("删除授权失败:{}", e.getMessage());
            invokeResult = InvokeResult.fail();
            invokeResult.setMessage("删除授权失败" + e.getMessage());
        }
        return invokeResult;
    }

    @Override
    public InvokeResult publishApi(Integer id) {
        return apiApplication.publishApi(id);
    }

    @Override
    public InvokeResult rescindApi(Integer id) {
        return apiApplication.rescindApi(id);
    }

    @Override
    public InvokeResult registApi(ApiDTO apiDTO, String username, Integer userid) {
        InvokeResult invokeResult;
        try {
            invokeResult = InvokeResult.success();
            apiApplication.registApi(apiDTO, username, userid);
            invokeResult.setMessage("api注册成功!");
        } catch (Exception e) {
            log.error("Api注册失败", e);
            invokeResult = InvokeResult.fail();
            invokeResult.setMessage("Api注册失败" + e.getMessage());
        }
        return invokeResult;
    }

    @Override
    public InvokeResult getMyApi(Integer userId, String groupId, String keyword, Integer pageNo, Integer pageSize, String sortField, String sortType, String sourceWay, String datasource) {
        InvokeResult myApi = null;
        try {
            myApi = apiApplication.getMyApi(userId, groupId, keyword, pageNo, pageSize, sortField, sortType, sourceWay, datasource);

        } catch (Exception e) {
            log.error("查询我的api失败:{}", e.getMessage());
        }
        return myApi;
    }

    @Override
    public InvokeResult listMarketApi(String keyword, Integer pageNo, Integer pageSize, String sortField, String sortType, Long startTime, Long endTime) {
        return apiApplication.listMarketApi(keyword, pageNo, pageSize, sortField, sortType, startTime, endTime);
    }

    @Override
    public InvokeResult listMyAuth(String username, Integer pageNo, Integer pageSize, String sortField, String sortType, Long startTime, Long endTime, String keyword, Integer userid) {
        return apiApplication.listMyAuth(username, pageNo, pageSize, sortField, sortType, startTime, endTime, keyword, userid);
    }

    @Override
    public InvokeResult dataView(Integer userId, Integer apiId, String username) {
        return apiApplication.dataView(userId, apiId, username);
    }

    @Override
    public InvokeResult executeApi(String apiName, Map<String, String> inParam, String username, Integer userid) {
        InvokeResult invokeResult;
        try {
            InvokeResult apiResult = apiApplication.executeApi(apiName, inParam, username, userid);
            return apiResult;
        } catch (Exception e) {
            log.error("执行Api失败", e);
            invokeResult = InvokeResult.fail();
            invokeResult.setMessage("执行Api失败" + e.getMessage());
        }
        return invokeResult;
    }

    @Override
    public List<String> getMysqlDataType() {
        return MysqlDataType.getDataTypes();
    }

    @Override
    public List<String> getSqlServerDataType() {
        return SqlServerDataType.getDataTypes();
    }

    @Override
    public InvokeResult queryApiSingle(Integer id) {
        return apiApplication.queryApiSingle(id);
    }

    @Override
    public InvokeResult queryAuthSingle(Integer apiId) {
        return apiApplication.queryAuthSingle(apiId);
    }

    @Override
    public InvokeResult getApiLimit() {
        return apiApplication.getApiLimit();
    }

}
