package com.zorkdata.apiservice.domain.repository;

import com.zorkdata.apiservice.domain.domain.ApiGroup;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @title: ApiApiServiceRepository
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/9 009-11:05
 */
public interface ApiGroupRepository extends JpaRepository<ApiGroup, Integer>, JpaSpecificationExecutor<ApiGroup> {


    /**
     * 查询是否存在 parent_id = id 的情况存在,借此判断是否属于叶子结点
     *
     * @param id
     * @return
     */
    @Query(value = "select count(*) from api_group where parent_id = ?1", nativeQuery = true)
    int selectParentId(Integer id);

    /**
     * 非空判断,查询该id是否存在
     *
     * @param id
     * @return
     */
    @Query(value = "select count(*) from api_group where id= ?1", nativeQuery = true)
    Integer selectCountFromId(Integer id);

    /**
     * 查看api发布状态
     *
     * @param id
     * @return
     */
    @Query(value = "select status from api where id= ?1", nativeQuery = true)
    Integer selectApiStatus(Integer id);

    /**
     * 发布api
     *
     * @param id
     * @return
     */
    @Modifying
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "UPDATE api a SET a.status = 1 where id= ?1", nativeQuery = true)
    void publishApi(Integer id);

    /**
     * 撤销发布api
     *
     * @param id
     * @return
     */
    @Modifying
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "UPDATE api a SET a.status = 0 where id= ?1", nativeQuery = true)
    void rescindApi(Integer id);

    /**
     * findByParentId
     *
     * @param parentId
     * @return
     */
    @Query(value = "select * from api_group where parent_id= ?1", nativeQuery = true)
    List<ApiGroup> findByParentId(Integer parentId);


    /**
     * findByGroupId
     *
     * @param id
     * @return
     */
    @Query(value = "select count(*) from api where group_id= ?1", nativeQuery = true)
    Integer findByGroupId(Integer id);
}
