package com.zorkdata.apiservice.domain.domain;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * @title: ApiCall
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/7 007-14:58
 */
@Table(name = "api_call")
@Data
@Entity
public class ApiCall {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Integer id;

    /**
     * 接口id
     */
    @Column(name = "api_id")
    private Integer apiId;
    /**
     * 调用时间
     */
    @Column(name = "call_time")
    private Date callTime;
    /**
     * 耗时
     */
    @Column(name = "duration")
    private Long duration;
    /**
     * 请求参数
     */
    @Column(name = "request_param")
    private String requestParam;
    /**
     * 返回结果
     */
    @Column(name = "result")
    private String result;
    /**
     * 调用者
     */
    @Column(name = "caller")
    private String caller;
    /**
     * 是否调用成功
     */
    @Column(name = "success")
    private Boolean success;
    /**
     * 错误类型
     */
    @Column(name = "error_type")
    private String errorType;


}
