package com.zorkdata.apiservice.domain.domain;

import com.zorkdata.apiservice.domain.dto.ApiAuthDTO;
import com.zorkdata.apiservice.domain.dto.RequestParamDTO;
import com.zorkdata.apiservice.domain.dto.ReturnParamDTO;
import com.zorkdata.apiservice.domain.repository.ApiRepository;
import com.zorkdata.dddlib.domain.AbstractEntity;
import lombok.Data;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;


/**
 * @author lixinfeng
 * @title: Api  接口
 * @date 2021/09/07
 */
@Table(name = "api")
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
public class Api extends AbstractEntity<Api, Integer, ApiRepository> {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Integer id;

    /**
     * 接口名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 请求路径
     */
    @Column(name = "path")
    private String path;

    /**
     * 描述
     */
    @Column(name = "description")
    private String description;

    /**
     * 调用超时时间(秒)
     */
    @Column(name = "overtime")
    private Integer overtime;

    /**
     * 单用户每秒调用次数限制
     */
    @Column(name = "single_limit")
    private Integer singleLimit;

    /**
     * 协议
     */
    @Column(name = "protocol")
    private String protocol;

    /**
     * 请求方式
     */
    @Column(name = "request_type")
    private String requestType;

    /**
     * 返回类型
     */
    @Column(name = "return_type")
    private String returnType;

    /**
     * 白名单
     */
    @Column(name = "white_list")
    private String whiteList;

    /**
     * 所属分组
     */
    @ManyToOne(targetEntity = ApiGroup.class)
    @JoinColumn(name = "group_id", referencedColumnName = "id")
    private ApiGroup group;

    /**
     * 数据源
     */
    @Column(name = "data_source")
    private String datasource;


    /**
     * 是否分页
     */
    @Column(name = "page")
    private Integer page;

    /**
     * 后端 Host
     */
    @Column(name = "source_host")
    private String sourceHost;

    /**
     * 后端路径
     */
    @Column(name = "source_path")
    private String sourcePath;


    /**
     * 返回结果是否携带分页参数
     */
    @Column(name = "page_param")
    private Integer pageParam;

    /**
     * sql语句
     */
    @Column(name = "query_sql")
    private String querySql;
    /**
     * 表名
     */
    @Column(name = "data_table")
    private String dataTable;
    /**
     * 正常结果返回示例
     */
    @Column(name = "right_case")
    private String rightCase;
    /**
     * 异常结果返回示例
     */
    @Column(name = "excepiton_case")
    private String excepitonCase;
    /**
     * 状态 0:未发布 1: 已发布
     */
    @Column(name = "status")
    private Integer status;
    /**
     * 用户id,接口生成者或注册者
     */
    @Column(name = "user_id")
    private Integer userId;
    /**
     * 接口来源 :create 生成  regist注册
     */
    @Column(name = "source_way")
    private String sourceWay;

    /**
     * 错误码定义
     */
    @Column(name = "error_code")
    private String errorCode;
    /**
     * 创建者
     */
    @Column(name = "created_by")
    private String createdBy;

    /**
     * 创建时间
     */
    @Column(name = "created_time", insertable = true, updatable = false, columnDefinition = "TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    @CreatedDate
    private Date createdTime;

    /**
     * 更新者
     */
    @Column(name = "updated_by")
    private String updatedBy;

    /**
     * 更新时间
     */
    @Column(name = "updated_time")
    @LastModifiedDate
    private Date updatedTime;


    /**
     * 常量参数列表
     */
    @Column(name = "const_param")
    private String constParams;

    @Column(name = "request_param")
    private String requestParam;

    @Column(name = "return_param")
    private String returnParam;

    @OneToMany(targetEntity = ApiAuth.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "api_id")
    private List<ApiAuth> apiAuthList;


}
