package com.zorkdata.apiservice.domain.assembler;

import com.zorkdata.apiservice.domain.domain.ApiGroup;
import com.zorkdata.apiservice.domain.dto.ApiGroupDTO;

import java.util.Date;

/**
 * @Author: lixinfeng
 * @Date: 2021/9/9 11:10
 * @Description:
 */
public class ApiGroupAssembler {

    public static ApiGroup toApiGroup(ApiGroupDTO apiGroupDTO, String username) {
        ApiGroup apiGroup = new ApiGroup();
        if (0 == apiGroupDTO.getId()) {
            apiGroup.setUpdatedBy(username);
            apiGroup.setUpdatedTime(new Date());
            apiGroup.setCreatedTime(new Date());
            apiGroup.setCreatedBy(username);
        } else {
            apiGroup.setId(apiGroupDTO.getId());
            apiGroup.setUpdatedBy(username);
            apiGroup.setUpdatedTime(new Date());
            apiGroup.setCreatedBy(username);
        }
        apiGroup.setName(apiGroupDTO.getName());
        apiGroup.setParentId(apiGroupDTO.getParentId());
        apiGroup.setDescription(apiGroupDTO.getDescription());
        return apiGroup;
    }
}
