package com.zorkdata.apiservice.domain.assembler;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.zorkdata.apiservice.domain.domain.Api;
import com.zorkdata.apiservice.domain.domain.ApiAuth;
import com.zorkdata.apiservice.domain.domain.ApiGroup;
import com.zorkdata.apiservice.domain.domain.ReturnParam;
import com.zorkdata.apiservice.domain.dto.*;
import com.zorkdata.apiservice.domain.listdto.WhiteListDTO;

import javax.sql.DataSource;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @title: ApiAssembler
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/9 009-23:16
 */
public class ApiAssembler {

    public static Api toApi(ApiDTO apiDTO, String username, Integer userid) {
        Api api = new Api();
        if (0 == apiDTO.getId()) {
            api.setCreatedTime(new Date());
            api.setUpdatedTime(new Date());
            api.setCreatedBy(username);
            api.setUpdatedBy(username);
            api.setUserId(userid);
        } else {
            api.setId(apiDTO.getId());
            api.setCreatedBy(username);
            api.setUserId(userid);
            api.setUpdatedTime(new Date());
        }
        api.setPath(apiDTO.getPath());
        api.setName(apiDTO.getName());
        api.setDescription(apiDTO.getDescription());
        api.setOvertime(apiDTO.getOvertime());
        api.setSingleLimit(apiDTO.getSingleLimit());
        api.setProtocol(apiDTO.getProtocol());
        api.setRequestType(apiDTO.getRequestType());
        api.setReturnType(apiDTO.getReturnType());
        api.setWhiteList(new Gson().toJson(apiDTO.getWhiteList()));
        api.setGroup(apiDTO.getGroup());
        api.setDatasource(new Gson().toJson(apiDTO.getDatasource()));
        api.setPage(apiDTO.getPage());
        api.setSourceHost(apiDTO.getSourceHost());
        api.setSourcePath(apiDTO.getSourcePath());
        api.setPageParam(apiDTO.getPageParam());
        api.setQuerySql(apiDTO.getQuerySql());
        api.setDataTable(apiDTO.getDataTable());
        api.setRightCase(apiDTO.getRightCase());
        api.setExcepitonCase(apiDTO.getExcepitonCase());
        api.setStatus(apiDTO.getStatus());
        api.setUserId(apiDTO.getUserId());
        api.setSourceWay(apiDTO.getSourceWay());
        api.setErrorCode(apiDTO.getErrorCode());
        api.setConstParams(new Gson().toJson(apiDTO.getConstParams()));
        api.setRequestParam(new Gson().toJson(apiDTO.getRequestParam()));
        api.setReturnParam(new Gson().toJson(apiDTO.getReturnParam()));
        return api;
    }

    public static ApiDTO toApiDTO(Api api) {
        ApiDTO apiDTO = new ApiDTO();

        apiDTO.setPath(api.getPath());
        apiDTO.setName(api.getName());
        apiDTO.setDescription(api.getDescription());
        apiDTO.setOvertime(api.getOvertime());
        apiDTO.setSingleLimit(api.getSingleLimit());
        apiDTO.setProtocol(api.getProtocol());
        apiDTO.setRequestType(api.getRequestType());
        apiDTO.setReturnType(api.getReturnType());
        String whiteList = api.getWhiteList();
        List<WhiteListDTO> requestParamDTOList = JSON.parseArray(whiteList, WhiteListDTO.class);

        apiDTO.setWhiteList(requestParamDTOList);
        apiDTO.setGroup(api.getGroup());

        String dataSource = api.getDatasource();
        DataSourceDTO dataSourceDTO = JSON.parseObject(dataSource, DataSourceDTO.class);
        apiDTO.setDatasource(dataSourceDTO);

        apiDTO.setPage(api.getPage());
        apiDTO.setSourceHost(api.getSourceHost());
        apiDTO.setSourcePath(api.getSourcePath());
        apiDTO.setPageParam(api.getPageParam());
        apiDTO.setQuerySql(api.getQuerySql());
        apiDTO.setDataTable(api.getDataTable());
        apiDTO.setRightCase(api.getRightCase());
        apiDTO.setExcepitonCase(api.getExcepitonCase());
        apiDTO.setStatus(api.getStatus());
        apiDTO.setUserId(api.getUserId());
        apiDTO.setSourceWay(api.getSourceWay());
        apiDTO.setErrorCode(api.getErrorCode());


        String constParams = api.getConstParams();
        List<ConstParamDTO> constParamDTO = JSON.parseArray(constParams, ConstParamDTO.class);
        apiDTO.setConstParams(constParamDTO);

        String requestParam = api.getRequestParam();
        List<RequestParamDTO> requestParamDTO = JSON.parseArray(requestParam, RequestParamDTO.class);
        apiDTO.setRequestParam(requestParamDTO);

        String returnParam = api.getReturnParam();
        List<ReturnParamDTO> returnParamDTO = JSON.parseArray(returnParam, ReturnParamDTO.class);
        apiDTO.setReturnParam(returnParamDTO);

        apiDTO.setId(api.getId());
        return apiDTO;
    }


}
