package com.zorkdata.apiservice.application.schedule;

import com.onlyone.paas.common.core.constant.SecurityConstants;
import com.zaxxer.hikari.HikariDataSource;
import com.zorkdata.apiservice.application.cache.DataSourceCache;
import com.zorkdata.apiservice.application.cache.UserCache;
import com.zorkdata.apiservice.application.dbutils.ConnectionManager;
import com.zorkdata.apiservice.common.api.feign.RemoteAuthCenterService;
import com.zorkdata.apiservice.common.api.feign.RemoteSmartService;
import com.zorkdata.apiservice.domain.domain.DataSource;
import com.zorkdata.apiservice.domain.domain.FieldInfo;
import com.zorkdata.apiservice.domain.domain.TableInfo;
import com.zorkdata.apiservice.domain.domain.User;
import com.zorkdata.dddlib.core.sdk.InvokeResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;

/**
 * @author zyw
 * @create 2021-09-15-17:41
 */
@Component
@EnableScheduling
@Slf4j
public class FetchAllUserFromAuthSchedule {
    public static final String ELASTICSEARCH_6 = "elasticsearch6";
    public static final String NAME = "name";
    public static final String USERNAME = "username";
    public static final String CONTENT = "content";
    public static final String TYPE = "type";
    public static final String URL = "url";
    public static final String ID = "id";
    public static final String IP = "ip";
    public static final String DATABASE_NAME = "databaseName";
    public static final String TABLE_NAME = "table_name";
    public static final String COLUMN_NAME = "column_name";
    public static final String DATA_TYPE = "data_type";
    public static final String NAMESPACE_ID = "namespaceId";
    private final int MYSQL_TYPE = 2;
    private final int ELASTICSEARCH6_TYPE = 5;
    private final int SQLSERVER_TYPE = 8;
    public static final String MYSQL = "mysql";
    public static final String SQLSERVER = "sqlserver";

    @Resource
    RemoteAuthCenterService remoteAuthCenterService;

    @Resource
    RemoteSmartService remoteSmartService;

    /**
     * 添加定时任务
     * 每小时执行一次
     */
    @Scheduled(cron = "0 0 0/1 * * ?")
    @PostConstruct
    private void fetchUserTask() {
        //查询所有用户
        InvokeResult invokeResult = remoteAuthCenterService.fetchAllUserFromAuth(SecurityConstants.FROM_IN);
        //解析
        Object data = invokeResult.getData();
        ArrayList list = (ArrayList) data;
        List<User> objects = new ArrayList<>();
        list.forEach(item -> {
            LinkedHashMap map = (LinkedHashMap) item;
            User user = new User();
            user.setId(Integer.parseInt(map.get("id").toString()));
            user.setUsername(map.get(NAME).toString());
            objects.add(user);
        });
        UserCache.setUsers(objects);
    }

    /**
     * 添加定时任务
     * 每小时执行一次
     */
    @Scheduled(cron = "0 0 0/1 * * ?")
    @PostConstruct
    private void fetchDatasourceTask() {

        //查询所有数据源
        InvokeResult invokeResult = remoteSmartService.queryDatasourceList(0, 10000, 1, SecurityConstants.FROM_IN);
        //解析
        LinkedHashMap map = (LinkedHashMap) invokeResult.getData();
        ArrayList dataSourceList = (ArrayList) map.get(CONTENT);
        Map<String, DataSource> dataSourceMap = new HashMap<>(16);

        for (int i = 0; i < dataSourceList.size(); i++) {
            LinkedHashMap dasourceMap = (LinkedHashMap) dataSourceList.get(i);
            int type = Integer.parseInt(dasourceMap.get(TYPE).toString());
            if (type == MYSQL_TYPE || type == ELASTICSEARCH6_TYPE || type == SQLSERVER_TYPE) {
                String typeName = "";
                switch (type) {
                    case MYSQL_TYPE:
                        typeName = MYSQL;
                        break;
                    case ELASTICSEARCH6_TYPE:
                        typeName = ELASTICSEARCH_6;
                        break;
                    case SQLSERVER_TYPE:
                        typeName = SQLSERVER;
                        break;
                    default:
                        break;
                }
                DataSource dataSource = new DataSource();
                String name = dasourceMap.get(NAME).toString();
                Object ipObj = dasourceMap.get(IP);
                String ip = (null == ipObj) ? null : ipObj.toString();
                Object urlObj = dasourceMap.get(URL);
                String url = (null == urlObj) ? null : urlObj.toString();
                Object userNameObj = dasourceMap.get(USERNAME);
                String userName = (null == userNameObj) ? null : userNameObj.toString();
                Object passwordObj = dasourceMap.get("password");
                String password = (null == passwordObj) ? null : passwordObj.toString();
                dataSource.setName(name);
                dataSource.setId(Integer.parseInt(dasourceMap.get(ID).toString()));
                dataSource.setType(Integer.parseInt(dasourceMap.get(TYPE).toString()));
                dataSource.setIp(ip);
                dataSource.setUrl(url);
                dataSource.setUsername(userName);
                dataSource.setPassword(password);
                dataSource.setDatabaseName(dasourceMap.get(DATABASE_NAME).toString());

                dataSource.setNamespaceId(Integer.parseInt(dasourceMap.get(NAMESPACE_ID).toString()));
                dataSource.setTypeName(typeName);

                //获取mysql和sqlserver已经创建的数据源
                HikariDataSource hikariDataSource = ConnectionManager.getDataSorce(name);

                List<String> tableNames = null;
                if (null != hikariDataSource) {
                    completeDataSource(tableNames, hikariDataSource, dataSource);
                } else {
                    if (type == MYSQL_TYPE) {
                        ConnectionManager.registMysqlDataSource(name, url, userName, password);
                        hikariDataSource = ConnectionManager.getDataSorce(name);
                        completeDataSource(tableNames, hikariDataSource, dataSource);
                    } else if (SQLSERVER_TYPE == type) {
                        ConnectionManager.registSqlServerDataSource(name, url, userName, password);
                        hikariDataSource = ConnectionManager.getDataSorce(name);
                        completeDataSource(tableNames, hikariDataSource, dataSource);
                    }
                    if (type != ELASTICSEARCH6_TYPE) {
                    }

                }
                dataSourceMap.put(dataSource.getName(), dataSource);
            }
        }
        DataSourceCache.setDataSources(dataSourceMap);
    }

    private void completeDataSource(List<String> tableNames, HikariDataSource hikariDataSource,DataSource dataSource ){
        List<TableInfo> tableInfoList = new ArrayList<>();
        tableNames = getTableNames(hikariDataSource, dataSource);
        for (String tableName : tableNames) {
            List<FieldInfo> fieldInfoList = getFieldInfoList(tableName, hikariDataSource, dataSource.getDatabaseName());
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName(tableName);
            tableInfo.setFieldInfoList(fieldInfoList);
            tableInfoList.add(tableInfo);
        }
        dataSource.setTableInfoList(tableInfoList);
    }

    private List<String> getTableNames(HikariDataSource hikariDataSource, DataSource dataSource) {
        List<String> databTableNames = new ArrayList<>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = hikariDataSource.getConnection();
            String poolName = hikariDataSource.getPoolName();
            String sql = "";
            if (MYSQL.equals(poolName)) {
                sql = "SELECT table_name as table_name FROM information_schema.tables  WHERE table_schema = '" + dataSource.getDatabaseName() + "' AND table_type = 'base table' ";
            } else if (SQLSERVER.equals(poolName)) {
                sql = "SELECT name as table_name FROM SysObjects Where XType='U' ORDER BY Name";
            }
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                String tableName = resultSet.getString(TABLE_NAME);
                databTableNames.add(tableName);
            }
        } catch (SQLException e) {
            log.error("获取数据表名列表异常{}", e.getMessage());
        } finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                } catch (Exception e) {
                    log.error("数据集关闭失败:{}", e.getMessage());
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                } catch (Exception e) {
                    log.error("statement关闭失败:{}", e.getMessage());
                }
            }
        }
        return databTableNames;
    }

    private List<FieldInfo> getFieldInfoList(String tableName, HikariDataSource hikariDataSource, String tabaleSchema) {
        Statement statement = null;
        ResultSet resultSet = null;

        List<FieldInfo> fieldInfoList = new ArrayList<>();
        String poolName = hikariDataSource.getPoolName();
        String sql = "";
        if (MYSQL.equals(poolName)) {
            sql = "select column_name,data_type from information_schema.columns where table_name = '" + tableName + "' and table_schema = '" + tabaleSchema + "'";
        } else if (SQLSERVER.equals(poolName)) {
            sql = "SELECT COLUMN_NAME, DATA_TYPE FROM INFORMATION_SCHEMA.columns WHERE TABLE_NAME = '" + tableName + "'";
        }
        try {
            Connection connection = hikariDataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                String fieldName = resultSet.getString(COLUMN_NAME);
                String dataType = resultSet.getString(DATA_TYPE);
                FieldInfo fieldInfo = new FieldInfo(fieldName, dataType);
                fieldInfoList.add(fieldInfo);
            }
        } catch (SQLException e) {
            log.error("获取数据字段列表异常{}", e.getMessage());
        } finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                } catch (Exception e) {
                    log.error("数据集关闭失败:{}", e.getMessage());
                }
            }

        }
        return fieldInfoList;
    }


}