package com.zorkdata.apiservice.application.dbutils;

import com.zaxxer.hikari.HikariDataSource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author zyw
 * @create 2021-09-09-10:39
 */
public class ConnectionManager {
    public static final String SQLSERVER = "sqlserver";
    public static final String MYSQL = "mysql";
    public static final String COM_MICROSOFT_SQLSERVER_JDBC_SQLSERVER_DATA_SOURCE = "com.microsoft.sqlserver.jdbc.SQLServerDataSource";
    public static final String URL = "url";
    public static final String USER = "user";
    private static Map<String, HikariDataSource> dataSourceMap = new ConcurrentHashMap<>();

    public static void registMysqlDataSource(String name, String url,String userName, String password){
        HikariDataSource hikariDataSource = new HikariDataSource();

        hikariDataSource.setJdbcUrl(url);
        hikariDataSource.setUsername(userName);
        hikariDataSource.setPassword(password);

        hikariDataSource.setConnectionTimeout(3000);
        hikariDataSource.setMaximumPoolSize(500);
        hikariDataSource.setMinimumIdle(20);
        hikariDataSource.setValidationTimeout(3000);
        hikariDataSource.setIdleTimeout(60000);
        hikariDataSource.setMaxLifetime(60000);
        hikariDataSource.setPoolName(MYSQL);

        dataSourceMap.put(name, hikariDataSource);
    }

    public static void registSqlServerDataSource(String name, String url,String userName, String password){
        HikariDataSource hikariDataSource = new HikariDataSource();
        System.out.println(hikariDataSource);
        hikariDataSource.setMaximumPoolSize(10);
        hikariDataSource.setDataSourceClassName(COM_MICROSOFT_SQLSERVER_JDBC_SQLSERVER_DATA_SOURCE);
        hikariDataSource.addDataSourceProperty(URL, url);
        hikariDataSource.addDataSourceProperty(USER, userName);
        hikariDataSource.addDataSourceProperty("password", password);
        hikariDataSource.setPoolName(SQLSERVER);

        dataSourceMap.put(name, hikariDataSource);
    }

    public static HikariDataSource getDataSorce(String name){
        return dataSourceMap.get(name);
    }

}
