package com.zorkdata.apiservice.application.application;

import com.zorkdata.apiservice.domain.domain.Api;
import com.zorkdata.apiservice.domain.domain.ApiAuth;
import com.zorkdata.apiservice.domain.domain.ApiGroup;
import com.zorkdata.apiservice.domain.dto.ApiAuthDTO;
import com.zorkdata.apiservice.domain.dto.ApiDTO;
import com.zorkdata.apiservice.domain.dto.ApiGroupDTO;
import com.zorkdata.dddlib.core.sdk.InvokeResult;
import org.springframework.data.domain.Page;

import java.util.Map;

/**
 * @title: ApiApiServiceApplication
 * @Author Linxinfeng
 * @Date: 2021-09-2021/9/9 009-10:45
 */
public interface ApiApplication {
    /**
     * 添加接口分组
     *
     * @param apiGroupDTO
     * @param username
     * @return
     */
    InvokeResult addGroup(ApiGroupDTO apiGroupDTO, String username);

    /**
     * 删除接口分组
     *
     * @param id
     * @return
     */
    InvokeResult deleteGroup(Integer id);

    /**
     * 查询单个接口分组
     *
     * @param id
     * @return
     */
    InvokeResult getGroup(Integer id);

    /**
     * 查询接口分组列表
     *
     * @param keyword
     * @param pageSize
     * @param pageNo
     * @param sortField
     * @param sortType
     * @return
     */
    Page<ApiGroup> listGroup(String keyword, Integer pageSize, Integer pageNo, String sortField, String sortType);

    /**
     * 保存Api接口
     *
     * @param apiDTO
     * @param username
     * @param userid
     * @return
     */
    Api addApi(ApiDTO apiDTO, String username, Integer userid);

    /**
     * 删除Api接口
     *
     * @param id
     * @return
     */
    InvokeResult deleteApi(Integer id);

    /**
     * 添加接口授权
     *
     * @param apiAuthDTO
     * @param username
     * @return
     */
    ApiAuth addAuth(ApiAuthDTO apiAuthDTO, String username);

    /**
     * 判断接口是否授权
     *
     * @param apiAuthDTO
     * @return
     */
    Integer selectUserId(ApiAuthDTO apiAuthDTO);

    /**
     * 查看Api发布状态
     *
     * @param apiAuthDTO
     * @return
     */
    Integer selectApiStatus(ApiAuthDTO apiAuthDTO);

    /**
     * 删除授权接口
     *
     * @param id
     * @return
     */
    InvokeResult deleteAuth(Integer id);

    /**
     * 发布接口
     *
     * @param id
     * @return
     */
    InvokeResult publishApi(Integer id);

    /**
     * 撤销发布接口
     *
     * @param id
     * @return
     */
    InvokeResult rescindApi(Integer id);

    /**
     * 新增注册Api
     *
     * @param apiDTO
     * @param username
     * @param userid
     * @return
     */
    Api registApi(ApiDTO apiDTO, String username, Integer userid);

    /**
     * 查询我创建的Api
     *
     * @param userId
     * @param groupId
     * @param keyword
     * @param pageNo
     * @param pageSize
     * @param sortField
     * @param sortType
     * @param sourceWay
     * @param datasource
     * @return
     */
    InvokeResult getMyApi(Integer userId, String groupId, String keyword, Integer pageNo, Integer pageSize, String sortField, String sortType, String sourceWay, String datasource);


    /**
     * 查询市场api
     *
     * @param keyword
     * @param pageNo
     * @param pageSize
     * @param sortField
     * @param sortType
     * @param startTime
     * @param endTime
     * @return
     */
    InvokeResult listMarketApi(String keyword, Integer pageNo, Integer pageSize, String sortField, String sortType, Long startTime, Long endTime);

    /**
     * 查看我授权的Api
     *
     * @param username
     * @param pageNo
     * @param pageSize
     * @param sortField
     * @param sortType
     * @param startTime
     * @param endTime
     * @param keyword
     * @param userid
     * @return
     */
    InvokeResult listMyAuth(String username, Integer pageNo, Integer pageSize, String sortField, String sortType, Long startTime, Long endTime, String keyword, Integer userid);

    /**
     * 数据预览成功
     *
     * @param userId
     * @param apiId
     * @param username
     * @return
     */
    InvokeResult dataView(Integer userId, Integer apiId, String username);

    /**
     * 接口执行的通用方法
     *
     * @param apiName
     * @param inParam
     * @param username
     * @return
     */
    InvokeResult executeApi(String apiName, Map<String, String> inParam, String username, Integer userid);

    /**
     * 获取所有系统用户列表
     *
     * @return
     */
    InvokeResult listAllUser();


    /**
     * 获取所有数据源列表
     *
     * @return
     */
    InvokeResult queryDatasourceList();

    /**
     * 根据id查询api
     *
     * @param id
     * @return
     */
    InvokeResult queryApiSingle(Integer id);

    /**
     * 根据apiId查询Auth
     *
     * @param apiId
     * @return
     */
    InvokeResult queryAuthSingle(Integer apiId);

    /**
     * 获取Api   Limit,name属性
     *
     * @return
     */
    InvokeResult getApiLimit();
}
