const webpack = require("webpack");
const CopyWebpackPlugin = require("copy-webpack-plugin");
const path = require("path");

module.exports = {
  runtimeCompiler: true,
  outputDir: "screen-box",
  publicPath: "",
  productionSourceMap: true,
  configureWebpack: {
    plugins: [
      new webpack.ProvidePlugin({
        $: "jquery",
        jQuery: "jquery",
        "windows.jQuery": "jquery"
      }),
      new CopyWebpackPlugin([
        {
          from: path.resolve(__dirname, "src/assets"),
          to: path.resolve(__dirname, "screen-box")
        }
      ])
    ],
    module: {
      rules: [
        {
          test: /\.md$/,
          use: [
            {
              loader: "html-loader"
            },
            {
              loader: "markdown-loader"
            }
          ]
        }
      ]
    }
  },
  devServer: {
    proxy: {
      "/dataconsistency/": {
        target: "http://192.168.2.58:8129",
        // target: "http://172.27.240.233:8129",
        changeOrigin: true,
        pathRewrite: { "^/dataconsistency/": "" }
      },
      "/auth/": {
        target: "http://paas.noahtest.com",
        changeOrigin: true,
        pathRewrite: { "^/auth/": "" }
      }
    }
  },
  css: {
    loaderOptions: {
      scss: {
        prependData: `@import "~@/assets/styles/_variables.scss";`
      }
    }
  }
};
