import Server from "@/axios/index.js";
import qs from "qs";
import * as CryptoJS from "crypto-js";
const paasServer =
  process.env.NODE_ENV === "development"
    ? "/auth/api/onlyone/auth/"
    : window.paasServer;

export default {
  // paas登录
  async login(data) {
    data.password = CryptoJS.AES.encrypt(
      data.password,
      CryptoJS.enc.Latin1.parse("paas for onlyone"),
      {
        iv: CryptoJS.enc.Latin1.parse("paas for onlyone"),
        mode: CryptoJS.mode.CBC,
        padding: CryptoJS.pad.ZeroPadding
      }
    ).toString();
    return await Server.axios(
      "post",
      paasServer,
      `oauth/token?${qs.stringify(data)}`,
      null,
      {
        "Content-Type": "application/x-www-form-urlencoded",
        isToken: false,
        Authorization: "Basic b25seW9uZTpvbmx5b25l"
      }
    );
  },
  // paas登出,清除token
  async outLogin() {
    return await Server.axios("delete", paasServer, "token/logout");
  }
};
