module.exports = {
  root: true,
  env: {
    node: true
  },
  globals: {  // 添加全局变量
    config: true,
    $: true,
    jsPlumb: true,
    jQuery: true,
    hljs: true
  },
  'extends': [
    "plugin:vue/essential", "eslint:recommended", "@vue/prettier"
  ],
  parserOptions: {
    parser: 'babel-eslint'
  },
  rules: {
    // 使用 ===  !==
    'eqeqeq': ['error', 'always'],
    // 不能使用var定义变量
    'no-var': 'error',
    // 可以使用全局变量
    'no-implicit-globals': 'off',
    'no-useless-escape': 'off'
  },
  overrides: [
    {
      files: [
        '**/__tests__/*.{j,t}s?(x)',
        '**/tests/unit/**/*.spec.{j,t}s?(x)'
      ],
      env: {
        jest: true
      }
    }
  ]
}