/**
 *
 * @param {*} rule
 * @param {*} value
 * @param {*} callback
 * @description 校验value 必须以字母开头，且只能输入字母和下划线，长度为4-30
 */
export function validateName(rule, value, callback) {
  const regTest = /^[\u4e00-\u9fa5a-zA-Z_]+[\u4e00-\u9fa5a-zA-Z_0-9]{0,50}$/;
  if (value === "") {
    callback(new Error("请输入名称"));
  } else if (value && value.length > 50) {
    callback(new Error("名称长度不大于50"));
  } else {
    if (!regTest.test(value)) {
      callback(
        new Error("名称以字母、下划线、汉字开头，支持字母,下划线，数字，汉字")
      );
    } else {
      callback();
    }
  }
}

export const validateGroupName = (rule, value, callback) => {
  const regTest = /^[\u4e00-\u9fa5a-zA-Z_]+[\u4e00-\u9fa5a-zA-Z_0-9]{0,50}$/;
  const regTest2 = /\s/;
  if (value === "") {
    callback(new Error("请输入名称"));
  } else if (value && value.length > 50) {
    callback(new Error("名称长度不大于50"));
  } else {
    if (regTest2.test(value)) {
      callback(new Error("名称不能包含空格"));
    } else if (!regTest.test(value)) {
      callback(
        new Error("名称以字母、下划线、汉字开头，支持字母,下划线，数字，汉字")
      );
    } else {
      callback();
    }
  }
};

export function validateNameInput(value) {
  const regTest = /^[\u4e00-\u9fa5a-zA-Z_]+[\u4e00-\u9fa5a-zA-Z_0-9]{0,50}$/;
  const regTest2 = /\s/;
  if (value === "") {
    return {
      result: false,
      message: "名称不能为空"
    };
  } else if (value && value.length > 50) {
    return {
      result: false,
      message: "名称长度不大于50"
    };
  } else {
    if (regTest2.test(value)) {
      return {
        result: false,
        message: "名称不能包含空格"
      };
    } else if (!regTest.test(value)) {
      return {
        result: false,
        message: "名称以字母、下划线、汉字开头，支持字母,下划线，数字，汉字"
      };
    } else {
      return {
        result: true,
        message: ""
      };
    }
  }
}

export const validateSymbol = (rule, value, callback) => {
  value = value.substr(-1, 1);
  const regTest = /^[\+\-\*\/\(\)]|[A-Za-z]$/;
  const regTest2 = /\s/;
  const regTes3 = /^[A-Za-z]$/;
  if (value === "") {
    callback(new Error("请输入名称"));
  } else {
    if (regTest2.test(value)) {
      callback(new Error("名称不能包含空格"));
    } else if (!regTest.test(value)) {
      callback(new Error("支持符号：+ - * / ( ) A-Za-z"));
    } else if (
      regTes3.test(value) &&
      window.letters &&
      !window.letters.includes(value) &&
      !window.letters.includes(value.toLocaleUpperCase())
    ) {
      callback(new Error("对应规则表达式不存在"));
    } else {
      callback();
    }
  }
};
