import Vue from "vue";
import VueRouter from "vue-router";
import Home from "../views/login-home/home.vue";
import Login from "../views/login-home/login.vue";

Vue.use(VueRouter);

const requireRoutes = require.context("@/views/", true, /routes.js/);
let combineRoutes = [],
  tempCombineRoutes = [];
requireRoutes.keys().forEach(fileName => {
  combineRoutes.push(requireRoutes(fileName).default);
});
combineRoutes.forEach(routes => {
  tempCombineRoutes = tempCombineRoutes.concat(routes);
});
const routes = [
  {
    path: "/login",
    name: "login",
    component: Login
  },
  {
    path: "/home",
    component: Home,
    children: tempCombineRoutes
  }
];

const router = new VueRouter({
  mode: "hash",
  base: process.env.BASE_URL,
  routes
});

router.beforeEach((to, from, next) => {
  try {
    window._axiosPromiseArr?.forEach(ele => {
      ele.cancel();
    });
    window._axiosPromiseArr = [];
  } catch (error) {
    console.log(error);
  }
  next();
});

export default router;
