// 获取元素的滚动坐标
export const getScrollPosition = (el = window) => ({
  x: el.pageXOffset !== undefined ? el.pageXOffset : el.scrollLeft,
  y: el.pageYOffset !== undefined ? el.pageYOffset : el.scrollTop
});

// 去除空格,type: 1-所有空格 2-前后空格 3-前空格 4-后空格
export const trim = (str, type) => {
  type = type || 1;
  switch (type) {
    case 1:
      return str.replace(/\s+/g, "");
    case 2:
      return str.replace(/(^\s*)|(\s*$)/g, "");
    case 3:
      return str.replace(/(^\s*)/g, "");
    case 4:
      return str.replace(/(\s*$)/g, "");
    default:
      return str;
  }
};

export const isString = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "String";
};

export const isNumber = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "Number";
};

export const isBoolean = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "Boolean";
};

export const isFunction = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "Function";
};

export const isNull = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "Null";
};

export const isUndefined = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "Undefined";
};

export const isObj = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "Object";
};

export const isArray = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "Array";
};

export const isDate = o => {
  return Object.prototype.toString.call(o).slice(8, -1) === "Date";
};

export function getCookieDomain() {
  let ipReg = /((2(5[0-5]|[0-4]\d))|[0-1]?\d{1,2})(\.((2(5[0-5]|[0-4]\d))|[0-1]?\d{1,2})){3}/g;
  let host = window.location.host;
  if (host.indexOf(":") !== -1) {
    host = host.split(":")[0];
  }
  if (!ipReg.test(host)) {
    let domainArr = host.split(".");
    host = domainArr.splice(1).join(".");
  }
  return host;
}
//空字段处理为--
export function handleSpace(list) {
  let tempList = JSON.parse(JSON.stringify(list));
  tempList.forEach(obj => {
    for (const key in obj) {
      obj[key] = !obj[key] && obj[key] !== 0 ? "--" : obj[key];
    }
  });
  return tempList;
}
