import Vue from "vue";
import Vuex from "vuex";
import createPersistedState from "vuex-persistedstate";
import { commonStore } from "./commonStore";
Vue.use(Vuex);

let combineModules = {
  commonStore
};
const modules = require.context("@/views/", true, /store.js/);
modules.keys().forEach(fileName => {
  let module = modules(fileName);
  combineModules[Object.keys(module)[0]] = module[Object.keys(module)[0]];
});
const store = new Vuex.Store({
  modules: combineModules,
  plugins: [
    createPersistedState({
      key: "data-consistency",
      storage: window.localStorage
    })
  ]
});

export default store;
