import Vue from "vue";
import App from "./App.vue";
import router from "./router";
import store from "./store";
import ElementUI from "element-ui";
import VueSimpleContextMenu from "vue-simple-context-menu";
import VueClipBoard from "vue-clipboard2";

import "element-ui/lib/theme-chalk/index.css";
import "vue-simple-context-menu/dist/vue-simple-context-menu.css";
import "./assets/styles/element.scss";

Vue.use(VueClipBoard);
Vue.use(ElementUI);
Vue.config.productionTip = false;
Vue.component("vue-simple-context-menu", VueSimpleContextMenu);

//自动注册通用组件
const requireComponent = require.context(
  "./components",
  true,
  /base-(\w|-)*.vue/
);
requireComponent.keys().forEach(fileName => {
  const componentConfig = requireComponent(fileName);
  const componentName = `base-${fileName.split("base-")[1]}`.split(".")[0];
  Vue.component(componentName, componentConfig.default || componentConfig);
});

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount("#app");
