package com.zork.zhtt.kafka;

import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

import java.util.*;
@Slf4j
public class Producer {
    //static String servers = "kafka-data1:9092,kafka-data2:9092,kafka-data2:9092";
    static int batchsize = 10000;
    static Producer testProducer;
    //static String metricTopic;
    static String errorLogTopic;
    static String defaultLogTopic = "test";
    private static String bootstrapServers = null;
    public static Map<String, String> APPSYSTEM_TOPIC_MAP = new HashMap<String, String>();

    static int partition = 8;
    private static KafkaProducer<String, byte[]> producer;
    private static KafkaProducer<String, String> noAvroProducer;

    public static synchronized Producer getInstance() {
        if (testProducer == null) {
            testProducer = new Producer();
        }
        return testProducer;
    }


    public static String getBootstrapServers() {
        return bootstrapServers;
    }

    public static void setBootstrapServers(String bootstrapServers) {
        Producer.bootstrapServers = bootstrapServers;
    }

    public Producer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "10.240.1.194:9092");
        props.put("client.id", "metricsend");
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("batch.size", batchsize);
        producer = new KafkaProducer<String, byte[]>(props);

        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        noAvroProducer = new KafkaProducer<String, String>(props);
    }


    private String getTopicByAppSystem(String appsystem) {
        if (APPSYSTEM_TOPIC_MAP.containsKey(appsystem)) {
            return APPSYSTEM_TOPIC_MAP.get(appsystem);
        }
        return defaultLogTopic;
    }

    public void sendLog(String appsystem, String logTypeName, String timestamp, String source, String offset, Map<String, String> dimensions, Map<String, Double> metrics,
                        Map<String, String> normalFields) {
        try {
            byte[] bytes = AvroSerializerFactory.getLogAvorSerializer().serializingLog(logTypeName, timestamp, source, offset, dimensions, metrics, normalFields);
            producer.send(new ProducerRecord<String, byte[]>(getTopicByAppSystem(appsystem), getLogPartitionKey(logTypeName, dimensions), bytes));
        } catch (Exception e) {
            log.info("excetion:",e);
        }
    }

    public void sendLogToOtherTopic(String output_topic, String logTypeName, String timestamp, String source, String offset, Map<String, String> dimensions, Map<String, Double> metrics,
                                    Map<String, String> normalFields) {
        try {
            byte[] bytes = AvroSerializerFactory.getLogAvorSerializer().serializingLog(logTypeName, timestamp, source, offset, dimensions, metrics, normalFields);
            producer.send(new ProducerRecord<String, byte[]>(output_topic,null, bytes));
        } catch (Exception e) {
            log.info("excetion:",e);
        }
    }

    public void sendLogToothertopic(String topic,String logJson) {
        try {
            noAvroProducer.send(new ProducerRecord<String, String>(topic, "", logJson));
        } catch (Exception e) {
            log.info("excetion:",e);
        }
    }
    public void sendErrorLog(String logJson) {
        try {
            noAvroProducer.send(new ProducerRecord<String, String>(errorLogTopic, "", logJson));
        } catch (Exception e) {
            log.info("excetion:",e);
        }
    }

    public void sendErrorLogStruct(String topic ,String logJson) {
        try {
            noAvroProducer.send(new ProducerRecord<String, String>(topic, "", logJson));
        } catch (Exception e) {
            log.info("excetion:",e);
        }
    }

    public void sendMetric(String metricTopic, String metricSetName, String timestamp, Map<String, String> dimensions, Map<String, Double> metrics) {
        try {
            byte[] bytes = AvroSerializerFactory.getMetricAvorSerializer().serializingMetric(metricSetName, timestamp, dimensions, metrics);
            String kafkaPartition = getMetricPartitionKey(metricSetName, dimensions);
            producer.send(new ProducerRecord<String, byte[]>(metricTopic, null, bytes));
        } catch (Exception e) {
              log.info("excetion:",e);
        }
    }

    public void sendAlarm(String alarmTopic, byte[] bytes) {
        try {
            producer.send(new ProducerRecord<String, byte[]>(alarmTopic, bytes));
        } catch (Exception e) {

        }
    }

    private static String getLogPartitionKey(String logTypeName, Map<String, String> dimensions) {
        try {
            return pK(logTypeName, dimensions, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return logTypeName;
    }

    private String getMetricPartitionKey(String metricsetName, Map<String, String> dimensions) {
        List<String> sorts = new ArrayList<String>();
        for (String key : dimensions.keySet()) {
            sorts.add(key);
        }

        Collections.sort(sorts);

        StringBuffer sb = new StringBuffer();
        sb.append(metricsetName);
        for (String key : sorts) {
            sb.append("_").append(dimensions.get(key));
        }
        return sb.toString();
    }

//	public String PrimaryKey(String logTypeName1,Map<String, String> dimensions,  String[] keys) throws Exception {
//		return MD5.sign(pK(logTypeName1, dimensions, keys));
//	}

    public static String pK(String metricsetname, Map<String, String> dimensions, String[] dimensionskey) {
        if (dimensions == null || dimensions.size() == 0) {
            return String.format("%s", metricsetname);
        }
        if (dimensionskey == null) {
            return String.format("%s/%s", metricsetname, sortedDimensions(dimensions));
        } else {
            return String.format("%s/%s", metricsetname, sortedDimensionskey(dimensions, dimensionskey));
        }

    }

    public static String sortedDimensionskey(Map<String, String> dimensions, String[] dimensionskey) {
        List<String> values = new ArrayList<>();
        for (String key : dimensionskey) {
            if (dimensions.containsKey(key)) {
                values.add(dimensions.get(key));
            }
        }
        if (values == null) {
            return "";
        }

        Collections.sort(values);

        String[] ret = new String[values.size()];
        int i = 0;
        for (String value : values) {
            ret[i] = String.format("%s", value);
            i++;
        }

        return join(",", ret);
    }

    public static String sortedDimensions(Map<String, String> dimensions) {
        if (dimensions == null) {
            return "";
        }

        int size = dimensions.size();

        if (size == 0) {
            return "";
        }

        if (size == 1) {
            for (String key : dimensions.values()) {
                return String.format("%s", key);
            }
        }


        List<String> values = new ArrayList<>();
        for (String v : dimensions.values()) {
            values.add(v);
        }
        Collections.sort(values);

        String[] ret = new String[size];
        int i = 0;
        for (String value : values) {
            ret[i] = String.format("%s", value);
            i++;
        }

        return join(",", ret);
    }

    public static String join(String join, String[] strAry) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strAry.length; i++) {
            if (i == (strAry.length - 1)) {
                sb.append(strAry[i]);
            } else {
                sb.append(strAry[i]).append(join);
            }
        }

        return new String(sb);
    }

    public static void main(String[] args) {
//        Producer.setBootstrapServers("192.168.1.92:9092,192.168.1.93:9092,192.168.1.95:9092");
        Producer.setBootstrapServers("10.240.1.194:9092");

        Producer producer = new Producer();
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("D", "D");
        Map<String, Double> metrics = new HashMap<>();
        metrics.put("ios", 1.0);
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("n", "N");
        //producer.sendLog("1231", "logtype", String.valueOf(new Date().getTime()), "me", "123", dimensions, metrics, normalFields);
        int a =100;
        for(int i=0 ;i<a;i++) {
            producer.sendMetric("m2logtest", "test", String.valueOf(new Date().getTime()), dimensions, metrics);
            producer.sendMetric("m2logtest", "test", String.valueOf(new Date().getTime()), dimensions, metrics);
            producer.sendMetric("m2logtest", "test", String.valueOf(new Date().getTime()), dimensions, metrics);
            producer.sendMetric("m2logtest", "test", String.valueOf(new Date().getTime()), dimensions, metrics);
            log.info("xieruchengong");
        }
    }

}
