package com.zork.zhtt.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zork.common.dto.MetricDTO;
import com.zork.common.service.InfluxDBService;
import com.zork.common.utils.DateUtil;
import com.zork.zhtt.kafka.AvroSerializerFactory;
import com.zork.zhtt.kafka.Producer;
import com.zork.zhtt.model.TIndicatorBizDO;
import com.zork.zhtt.service.ITIndicatorBizService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;

import static com.zork.common.constant.DimensionConstant.APP_SYSTEM;
import static com.zork.common.utils.DateUtil.dateToStamp;
import static com.zork.zhtt.constant.InfoConstant.*;
import static com.zork.zhtt.constant.ZhttConstants.*;


@Slf4j
@Component
public class DataBaseQueryComponent {

    @Value("${send.metric-url}")
    private String sendMetricUrl;

    @Resource
    private ITIndicatorBizService itIndicatorBizService;

    @Resource
    private RestTemplate restTemplate;

    /**
     * thread pools   如果线程池长度超过处理需要，可灵活回收空闲线程，若无可回收，则新建线程
     */
    protected ExecutorService EXECUTOR_POOL = Executors.newCachedThreadPool();
    //Producer producer = new Producer();
    public static final int num = 0;
    //private static KafkaProducer<String, byte[]> producer;

    /**
     * 执行Sql输出统计Json
     */
//    @Scheduled(cron = "${schedules}")
//    public void execute() {
//        try {
//            List<TIndicatorBizDO> tIndicatorBizList = itIndicatorBizService.findByClzNameOrInfo();
//            EXECUTOR_POOL.execute(() -> {
//                // 根据数据条数遍历
//                tIndicatorBizList.forEach(tIndicatorBizDO -> {
//                    // 构建dimensions
//                    JSONArray jsonArray = JSONObject.parseArray(StringEscapeUtils.unescapeJava(tIndicatorBizDO.getInfo()));
//                    jsonArray.forEach(obj -> {
//                        // 获取Statistics数组
//                        JSONArray statisticsArray = ((JSONObject) obj).getJSONArray(STATISTICS);
//                        statisticsArray.forEach(object -> {
//                            JSONObject info = (JSONObject) object;
//                            //log.info(info.toString());
//                            Map<String, String> dimensions = new HashMap<>();
//                            dimensions.put(APP_SYSTEM, DYSJZJY_SYSTEM);
//                            dimensions.put(UN_KEY, tIndicatorBizDO.getUnKey());
//                            dimensions.put(INSTANCE_ID, tIndicatorBizDO.getAppName());
//                            dimensions.put(APP, tIndicatorBizDO.getApp());
//                            dimensions.put(FUNC_NO, info.getString(FUNC_NO));
//                            dimensions.put(DOWNCUSTER_NAME,StringUtils.isNotEmpty(info.getString(DOWNCUSTER_NAME)) ? info.getString(DOWNCUSTER_NAME) : "nothing");
//                            Map<String, Double> measures = new HashMap<>(7);
//                            measures = buildMeasures(info);
//
//                            MetricDTO metricDTO = new MetricDTO();
//                            metricDTO.setMetricsetname(DYS_LATENCY);
//                            metricDTO.setTimestamp(tIndicatorBizDO.getAddTime().getTime());
//                            metricDTO.setDimensions(dimensions);
//                            //metricDTO.setMeasures(buildMeasures(info));
//                            //构建measures值
//                             //metricDTO.setMeasures(buildMeasuresValue(info));
//                             sendMetric2Kafka(metricDTO);
//                              sendKfaka("");
//                        });
//                    });
//                });
//            });
//        } catch (Exception e) {
//            log.error("\n Query MetricDataExecute: -> {}", e.getMessage());
//        }
//    }

    @Scheduled(cron = "${schedules}")
    public void execute() {
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("D", "D");
        Map<String, Double> metrics = new HashMap<>();
        metrics.put("ios", 1.0);
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("n", "N");
        int a =100;
        for(int i=0 ;i<a;i++) {
            sendKfaka("m2logtest", "test", String.valueOf(new Date().getTime()), dimensions, metrics);
            sendKfaka("m2logtest", "test", String.valueOf(new Date().getTime()), dimensions, metrics);
            sendKfaka("m2logtest", "test", String.valueOf(new Date().getTime()), dimensions, metrics);
            sendKfaka("m2logtest", "test", String.valueOf(new Date().getTime()), dimensions, metrics);
            log.info("xieruchengong");
        }
    }











    /**
     * @param info
     * @return measures
     */
    private Map<String, String> buildMeasuresValue(JSONObject info) {
        Map<String, String> measures = new HashMap<>(7);
        measures.put(AVG_OF_ALL, StringUtils.isNotEmpty(info.getString(AVG_OF_ALL)) ? info.getString(AVG_OF_ALL) : "0");
        measures.put(NUMBER_OF_CALL, StringUtils.isNotEmpty(info.getString(NUMBER_OF_CALL)) ? info.getString(NUMBER_OF_CALL) : "0");
        measures.put(LONG_CALL_LATENCY, StringUtils.isNotEmpty(info.getString(LONG_CALL_LATENCY)) ? info.getString(LONG_CALL_LATENCY) : "0");
        measures.put(TOTAL_LATENCY, StringUtils.isNotEmpty(info.getString(TOTAL_LATENCY)) ? info.getString(TOTAL_LATENCY) : "0");
        measures.put(AVG_OF_THREESEC, StringUtils.isNotEmpty(info.getString(AVG_OF_THREESEC)) ? info.getString(AVG_OF_THREESEC) : "0");
        measures.put(NUMBER_OF_CALL_THREESEC, StringUtils.isNotEmpty(info.getString(NUMBER_OF_CALL_THREESEC)) ? info.getString(NUMBER_OF_CALL_THREESEC) : "0");
        //log.info(measures.toString());
        return measures;
    }

    private Map<String, Double> buildMeasures(JSONObject info) {
        Map<String, Double> measures = new HashMap<>(7);
        measures.put(AVG_OF_ALL, Double.valueOf(StringUtils.isNotEmpty(info.getString(AVG_OF_ALL)) ? info.getString(AVG_OF_ALL) : "0"));
        measures.put(NUMBER_OF_CALL, Double.valueOf(StringUtils.isNotEmpty(info.getString(NUMBER_OF_CALL)) ? info.getString(NUMBER_OF_CALL) : "0"));
        measures.put(LONG_CALL_LATENCY, Double.valueOf(StringUtils.isNotEmpty(info.getString(LONG_CALL_LATENCY)) ? info.getString(LONG_CALL_LATENCY) : "0"));
        measures.put(TOTAL_LATENCY, Double.valueOf(StringUtils.isNotEmpty(info.getString(TOTAL_LATENCY)) ? info.getString(TOTAL_LATENCY) : "0"));
        measures.put(AVG_OF_THREESEC, Double.valueOf(StringUtils.isNotEmpty(info.getString(AVG_OF_THREESEC)) ? info.getString(AVG_OF_THREESEC) : "0"));
        measures.put(NUMBER_OF_CALL_THREESEC, Double.valueOf(StringUtils.isNotEmpty(info.getString(NUMBER_OF_CALL_THREESEC)) ? info.getString(NUMBER_OF_CALL_THREESEC) : "0"));
        //log.info(measures.toString());
        return measures;
    }


    private void sendMetric2Kafka(MetricDTO metricDTO) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity<>(JSONObject.toJSON(metricDTO), headers);
            ResponseEntity<String> result = restTemplate.exchange(sendMetricUrl, HttpMethod.POST, entity, String.class);

            // 调用失败缺少measure值时，进行补齐重新调归补用递
            if (!Objects.requireNonNull(result.getBody()).contains("OK")) {
                log.info("sendMetric2Kafka SUCCESS,调用参数: ->{}  ,接口调用Result: ->{}", JSONObject.toJSON(metricDTO), result.getBody());
            }
        } catch (Exception e) {
            log.error("sendMetric2Kafka Exception: -> {} ,调用参数: ->{}", e.getMessage(), JSONObject.toJSON(metricDTO));
        }
    }
    private void sendKfaka(String metricTopic, String metricSetName, String timestamp, Map<String, String> dimensions, Map<String, Double> metrics) {
        Properties properties = new Properties();
        // kafka群组集群地址
        properties.put("bootstrap.servers", "10.240.1.194:9092");
        properties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        KafkaProducer<String, byte[]> producer = new KafkaProducer<>(properties);
        try {
            ProducerRecord<String, byte[]> record;
            byte[] bytes = AvroSerializerFactory.getMetricAvorSerializer().serializingMetric(metricSetName, timestamp, dimensions, metrics);
            record = new ProducerRecord<String, byte[]>(metricTopic, null,bytes);
            // 发送并发忘记
            producer.send(record);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            producer.close();
        }
    }



}
