package com.zork.zhtt.properties;



import com.zork.zhtt.dto.SchedulesDTO;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * @Author: Prock.Liy
 * @Date： 2021/6/2
 * @Description：
 */
@Component
@ConfigurationProperties(prefix = SchedulesProperties.PROPERTIES_PREFIX )
@Data
public class SchedulesProperties {

    public static final String PROPERTIES_PREFIX = "schedules";

    /**
     * Cron信息
     */
    private List<SchedulesDTO> schedulesDTOList;

    public List<SchedulesDTO> getSchedulesDTOList() {
        return schedulesDTOList;
    }

    public SchedulesProperties setSchedulesDTOList(List<SchedulesDTO> schedulesDTOList) {
        this.schedulesDTOList = schedulesDTOList;
        return this;
    }
}
