package com.zork.commission.properties;

import com.zork.commission.dto.DataSourceDTO;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/2
 * @Description：
 */

@Component
@ConfigurationProperties(prefix = DataSourceProperties.PROPERTIES_PREFIX )
public class DataSourceProperties {

    public static final String PROPERTIES_PREFIX = "database";

    /**
     * 数据库链接信息
     */
    private List<DataSourceDTO> dataSourceDTOList;

    public List<DataSourceDTO> getDataSourceDTOList() {
        return dataSourceDTOList;
    }

    public DataSourceProperties setDataSourceDTOList(List<DataSourceDTO> dataSourceDTOList) {
        this.dataSourceDTOList = dataSourceDTOList;
        return this;
    }
}
