package com.zork.send.kafka;

import com.alibaba.fastjson.JSON;
import com.zork.send.kafka.kafka.Producer;
import com.zork.send.kafka.model.KafkaConfig;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;

import static com.zork.common.utils.YamlUtil.getResMap;
import static com.zork.send.kafka.component.SendKafkaComponent.seekData;

@Slf4j
public class SendKafkaApplication {

    /**
     * 获取kafka配置文件信息
     *
     * @param filePath 配置文件路径
     * @return
     */
    public KafkaConfig seekKafkaYml(String filePath) {
//        Map<String, Object> map = new Yaml().load(this.getClass()
//                .getClassLoader()
//                .getResourceAsStream("application-kafka.yml"));
        Map<String, Object> map = getResMap(filePath, "kafka");
        return JSON.parseObject(JSON.toJSONString(map), KafkaConfig.class);
    }


    /**
     * 程序入口
     *
     * @param args 传入文件路径
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            log.error("启动参数错误:{},请输入正确参数格式！", args);
            log.error("参考如下: {}", "【java -jar **.jar /opt/app/application-kafka.yml】");
            return;
        }
        // 获取yaml配置信息
        KafkaConfig kafkaConfig = new SendKafkaApplication().seekKafkaYml(args[0]);

        // 创建字符串信息
        List<String> valueList = seekData(kafkaConfig.getSendSize(), kafkaConfig.getMessageArraySize());

        // sendKafka
        new Producer(valueList, kafkaConfig).start();

        System.out.println(kafkaConfig.getServers().getBytes().length);


    }

}
