package com.zork.htpocesb.component;

import com.zork.common.constant.DateConstant;
import com.zork.htpocesb.constant.DataConstant;
import com.zork.common.dto.KeyValueDTO;
import com.zork.common.service.InfluxDBService;
import com.zork.common.utils.FileUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.influxdb.dto.Point;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import static com.zork.common.utils.DateUtil.dateToStamp;

/**
 * @Author: Prock.Liy
 * @Date： 2021/7/21
 * @Description：
 */
@Slf4j
public class CsvWriteInfluxDBComponent {

    /**
     * 解析CSV数据，进行匹对后写入InfluxDB
     *
     * @param influxDBConnect InfluxDB
     * @param csvFilePath     csvFilePath
     */
    public static void invoke(InfluxDBService influxDBConnect, String csvFilePath) {
        try {
            int throughputCount = 0;
            int businessCount = 0;
            int esbCount = 0;
            influxDBConnect.influxDbBuild();
            influxDBConnect.createRetentionPolicy(DataConstant.AUTOGEN);

            // 解析csv文件数据为Map格式
            KeyValueDTO keyValueDTO = FileUtil.readCsv(csvFilePath);

            List<Point> pointList = new LinkedList<>();
            for (String valueArray : keyValueDTO.getValueList()) {
                // 时间格式转换
                long timestamp = dateToStamp(StringUtils.substringBefore(valueArray, ";"), DateConstant.SS_XXX_TIME_08);
                // 获取维度值
                List<String> valueList = Arrays.asList(StringUtils.substringAfter(valueArray, ";").split(";"));

                int count = 0;
                if (keyValueDTO.getKeyList().size() == valueList.size()) {

                    for (String value : valueList) {
                        if (DataConstant.NULL.equals(value)) {
                            count++;
                            continue;
                        }
                        // 赋值fields
                        String key = keyValueDTO.getKeyList().get(count).trim();
                        List<String> keyValueList = Arrays.asList(key.split(" "));
                        switch (keyValueList.size()) {
                            case 1:
                                pointList.add(
                                        Point.measurement(DataConstant.THROUGHPUT)
                                                .time(timestamp, TimeUnit.MILLISECONDS)
                                                .addField(DataConstant.THROUGHPUT_METRIC, Double.valueOf(value))
                                                .tag(DataConstant.IP, keyValueList.get(0))
                                                .build()
                                );
                                throughputCount++;
                                break;
                            case 2:
                                pointList.add(
                                        Point.measurement(DataConstant.ESB_SYSTEM)
                                                .time(timestamp, TimeUnit.MILLISECONDS)
                                                .addField(DataConstant.ESB_SYSTEM_METRIC, Double.valueOf(value))
                                                .tag(DataConstant.IP, keyValueList.get(0))
                                                .tag(DataConstant.SYSTEM_ID, keyValueList.get(1))
                                                .build()
                                );
                                esbCount++;
                                break;
                            case 3:
                                pointList.add(
                                        Point.measurement(DataConstant.BUSINESS)
                                                .time(timestamp, TimeUnit.MILLISECONDS)
                                                .addField(DataConstant.FUNCTION_METRIC, Double.valueOf(value))
                                                .tag(DataConstant.IP, keyValueList.get(0))
                                                .tag(DataConstant.SYSTEM_ID, keyValueList.get(1))
                                                .tag(DataConstant.FUNC_ID, keyValueList.get(2))
                                                .build()
                                );
                                businessCount++;
                                break;
                        }
                        count++;
                    }
                }
            }
            influxDBConnect.insertBatch(pointList, 100000);

//            if (throughputCount != 0) {
//                log.info("Throughput import Success, number:{}", throughputCount);
//            }
//            if (esbCount != 0) {
//                log.info("Esb system time consuming import Success, number:{}", esbCount);
//            }
//            if (businessCount != 0) {
//                log.info("Business system time consuming import Success, number:{}", businessCount);
//            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("数据匹对出错,本次导入InfluxDB任务退出!，Error:【\033[31m{}\033[0m】", e.getMessage());
        }

    }

}
