package com.zork.common.utils;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import com.zork.common.dto.KeyValueDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @Author: Prock.Liy
 * @Date： 2021/7/21
 * @Description：
 */
@Slf4j
public class FileUtil {

    /**
     * 写文件
     *
     * @param fileName
     * @param content
     */
    public static void appendMethodB(String fileName, String content, boolean isAppend) {
        try {
            // 打开一个写文件器，构造函数中的第二个参数true表示以追加形式写文件,如果为 true，则将字节写入文件末尾处，而不是写入文件开始处
            FileWriter writer = new FileWriter(fileName, isAppend);
            if (isAppend = true) {
                writer.write(content + "\n");
            } else {
                writer.write(content);
            }

            writer.flush();
            writer.close();
        } catch (IOException e) {
            log.error("\n 文件写入异常: -> {}", e.getMessage());
        }
    }

    /**
     * 获取文件行数
     *
     * @param filePath filePath
     * @return Integer
     */
    public static Integer readerFileRow(String filePath) {
        int linenumber = 0;
        try {
            File file = new File(filePath);
            if (file.exists()) {
                FileReader fr = new FileReader(file);
                LineNumberReader lnr = new LineNumberReader(fr);
                while (lnr.readLine() != null) {
                    linenumber++;
                }
                lnr.close();
            } else {
                log.error("File does not exists!");
            }
        } catch (IOException e) {
            e.printStackTrace();
            log.error("readerFileRow Exception!");
        }
        return linenumber;
    }

    /**
     * 读取csv文件
     *
     * @param csvFile 路径
     */
    public static KeyValueDTO readCsv(String csvFile) {
        KeyValueDTO keyValueDTO = new KeyValueDTO();
        CSVReader reader = null;
        try {
            reader = new CSVReader(new FileReader(csvFile));
            String[] line;
            String key = StringUtils.EMPTY;
            int index = 0;
            List<String> valueList = new ArrayList<>();
            while ((line = reader.readNext()) != null) {
                // 获取key
                if (index == 0) {
                    key = StringUtils
                            .substringAfter(String.join("; ", line), ";")
                            .replaceAll("\"", "").trim();
                    keyValueDTO.setKeyList(Arrays.asList(key.split(";")));
                }
                // 存储value
                if (index != 0) {
                    valueList.add(String.join(";", line));
                }
                index++;
            }
            keyValueDTO.setValueList(valueList);
        } catch (IOException | CsvValidationException e) {
            log.error("解析文件数据出错,本次导入InfluxDB任务退出!，Error:【\033[31m{}\033[0m】", e.getMessage());
        }
        return keyValueDTO;
    }

    /**
     * 获取文件
     */
    public static class MyExtFilter implements FilenameFilter {

        private final String ext;

        public MyExtFilter(String ext) {
            this.ext = ext;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(ext);
        }
    }

    /**
     * 读取文件内容
     *
     * @param filePath
     * @return
     */
    public static String readFile(String filePath) {
        //java 8中这样写也可以
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader br = Files.newBufferedReader(Paths.get(filePath))) {
            String line;
            while ((line = br.readLine()) != null) {
                buffer.append(line + "\n");
            }
        } catch (Exception e) {
            log.error("readFile Error:{} , filePath:{}", e.getMessage(), filePath);
        }
        return buffer.toString();
    }

    /**
     * 根据txt文件判断是否为交易日
     *
     * @param filePath
     * @return
     */
    public static boolean judgeTradingDay(String filePath, String today) {
        try (BufferedReader br = Files.newBufferedReader(Paths.get(filePath))) {
            String day;
            while ((day = br.readLine()) != null) {
                if (today.equals(day)) {
                    return true;
                }
            }
        } catch (Exception e) {
            log.error("judgeTradingDay Error , filePath:{}  Error: {}", filePath, e.getMessage());
        }
        return false;
    }

}
