/*
 * Decompiled with CFR 0.152.
 */
package com.zork.common.handler;

import com.zork.common.entity.ZorkResponse;
import com.zork.common.exception.ZorkException;
import java.nio.file.AccessDeniedException;
import java.util.List;
import java.util.Set;
import javax.security.auth.message.AuthException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

public class BaseExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ZorkResponse handleException(Exception e) {
        log.error("\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        return new ZorkResponse().message("\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38");
    }

    @ExceptionHandler(value={AuthException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ZorkResponse handleCloudAuthException(AuthException e) {
        log.error("\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
        return new ZorkResponse().message(e.getMessage());
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public ZorkResponse handleAccessDeniedException() {
        return new ZorkResponse().message("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u8d44\u6e90");
    }

    @ExceptionHandler(value={ZorkException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ZorkResponse handleCloudException(ZorkException e) {
        log.error("\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
        return new ZorkResponse().message(e.getMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ZorkResponse handleConstraintViolationException(ConstraintViolationException e) {
        StringBuilder message = new StringBuilder();
        Set violations = e.getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            Path path = violation.getPropertyPath();
            String[] pathArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)path.toString(), (String)".");
            message.append(pathArr[1]).append(violation.getMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return new ZorkResponse().message(message.toString());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ZorkResponse handleBindException(BindException e) {
        StringBuilder message = new StringBuilder();
        List fieldErrors = e.getBindingResult().getFieldErrors();
        for (FieldError error : fieldErrors) {
            message.append(error.getField()).append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return new ZorkResponse().message(message.toString());
    }
}

