package com.zork.other2jrsjcs.confg;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import java.time.Duration;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/17
 * @Description：
 */
@Configuration
public class RestTemplateConfig {

    @Value("${resttemplate.connect-timeout}")
    private Integer connectTime;

    @Value("${resttemplate.read-timeout}")
    private Integer readTime;

    @Bean
    public RestTemplate restTemplate() {
        // 设置超时时间
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(connectTime);
        requestFactory.setReadTimeout(readTime);
        return new RestTemplate(requestFactory);
    }
}
