package com.zork.parse.component;

import com.zork.parse.kafka.Consumer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

/**
 * @Author: Prock.Liy
 * @Date： 2022/4/20
 * @Description： 解密Kafka数据入库
 */
@Slf4j
@Component
public class ParseComponent  implements ApplicationRunner{

    @Value("${send.log-url}")
    private String sendLogUrl;

    @Value("${kafka.topic}")
    private String topic;

    @Value("${kafka.bootstrap.servers}")
    private String servers;

    @Value("${kafka.group.id}")
    private String groupId;

    @Value("${kafka.auto.offset.reset}")
    private String reset;

    @Value("${logTypeName}")
    private String logTypeName;

    @Resource
    private RestTemplate restTemplate;


    @Override
    public void run(ApplicationArguments args) throws Exception {
        new Consumer(topic,servers,groupId,reset,logTypeName).messageConsumer(restTemplate,sendLogUrl);
    }

}
