package com.zork.gondb.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Prock.Liy
 * @Date： 2021/9/6
 * @Description：
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "t_order")
public class OrderDO {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private String id;

    @Column(name = "type")
    private String type;

    @Column(name = "partition_name")
    private String partitionName;

    @Column(name = "agw_info")
    private String agwInfo;

    @Column(name = "agw_seq_id")
    private Long agwSeqId;

    @Column(name = "te_partition_no")
    private String tePartitionNo;

    @Column(name = "client_id")
    private String clientId;

    @Column(name = "cl_ord_id")
    private String clOrdId;

    @Column(name = "cl_ord_no")
    private Integer clOrdNo;

    @Column(name = "pbu_id")
    private String pbuId;

    @Column(name = "offer_pbu_id")
    private String offerPbuId;

    @Column(name = "branch_id")
    private String branchId;

    @Column(name = "offer_branch_id")
    private String offerBranchId;

    @Column(name = "business_type")
    private Integer businessType;

    @Column(name = "security_type")
    private Integer securityType;

    @Column(name = "market_id")
    private Integer marketId;

    @Column(name = "transact_time")
    private Long transactTime;

    @Column(name = "cust_id")
    private String custId;

    @Column(name = "fund_account_id")
    private String fundAccountId;

    @Column(name = "side")
    private String side;

    @Column(name = "ord_type")
    private String ordType;

    @Column(name = "client_seq_id")
    private Long clientSeqId;

    @Column(name = "enforce_flag")
    private String enforceFlag;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "create_user")
    private String createUser;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "update_user")
    private String updateUser;

    @Column(name = "offer_way")
    private String offerWay;

    @Column(name = "user_info")
    private String userInfo;

    @Column(name = "order_way")
    private String orderWay;

    @Column(name = "time_in_force")
    private String timeInForce;

    @Column(name = "entrust_date")
    private Integer entrustDate;

    @Column(name = "time_type")
    private Integer timeType;

    @Column(name = "order_group")
    private String orderGroup;

    @Transient
    private Integer ordStatus;

    @Transient
    private Integer rejectreasonCode;

    @Transient
    private String ordRejReason;

    @Transient
    private String exErrMsg;




}
