package com.zork.junhiro.trading.count.config;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * @Author: Prock.Liy
 * @Date： 2021/6/7
 * @Description：JdbcTemplateConfig
 */
@Configuration
public class JdbcTemplateConfig {

    @Bean
    public JdbcTemplate jdbcTemplateMsdb(@Qualifier("msdb") DataSource msdb) {
        return new JdbcTemplate(msdb);
    }

    @Bean
    public JdbcTemplate jdbcTemplateAppBusiness(@Qualifier("appBusiness") DataSource appBusiness) {
        return new JdbcTemplate(appBusiness);
    }

}
